<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\Auth;
use Hesto\MultiAuth\Traits\LogsoutGuard;
use Illuminate\Http\Request;
use App\Models\LoginActivity;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers, LogsoutGuard {
        LogsoutGuard::logout insteadof AuthenticatesUsers;
    }

    /**
     * Where to redirect users after login / registration.
     *
     * @var string
     */
    //public $redirectTo = '/admin/home';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('admin.guest', ['except' => 'logout']);
    }

    /**
     * Show the application's login form.
     *
     * @return \Illuminate\Http\Response
     */
    public function showLoginForm()
    {
        return view('admin.auth.login');
    }

    /**
     * Get the guard to be used during authentication.
     *
     * @return \Illuminate\Contracts\Auth\StatefulGuard
     */
    protected function guard()
    {
        return Auth::guard('admin');
    }
	
	/*protected function credentials(Request $request)
	{
	
		return array_merge($request->only($this->username(), 'password'), ['payment_status' => 'Paid']);
		
	}*/
	
	protected function authenticated(Request $request, $user)
    {
        /*if ( Auth::guard('admin')->user()->payment_status!='Paid' ) {// do your magic here
            return redirect('admin/stripe');
        }*/
		
		LoginActivity::create([
			'admin_id' => Auth::guard('admin')->user()->id,
			'ip_address' => $_SERVER['REMOTE_ADDR'],
			'user_agent' => get_browser_name($_SERVER['HTTP_USER_AGENT'])
		]);
		
		if(Auth::guard('admin')->user()->utype=='Treasury')
		{
		return redirect('admin/accounting');
		}
		else
		{
		return redirect('admin/home');
		}
        
    }
	
	
	
}
