<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Helpers\Helper;

use Auth;
use Exception;
use \Carbon\Carbon;

use App\Models\Donor;
use App\Models\Receipt;

class AjaxController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('admin');
    } 

	public function loadReceiptData(Request $request)
    {
        $receipt_id = $request->receipt_id;
		
		$receipt = Receipt::with('adminInfo','donorInfo')->where('id',$receipt_id)->first();
		
		return view('ajax.receipt-info', compact('receipt'));
		
    }
	
	
	public function markPaidReceipt(Request $request)
    {
        $receipt_id = $request->receipt_id;
		
		$receipt = Receipt::where('id',$receipt_id)->first();
		$receipt->payment_status = 'Paid';
		$receipt->save();
		
		$receipt = Receipt::with('adminInfo','donorInfo')->where('id',$receipt_id)->first();
		
		return view('ajax.receipt-info', compact('receipt'));
		
    }
	
	
	public function fetchDonor(Request $request)
    {
	//echo 'taran';
		 	//$query = $request->get('query');
			$query = '9876';
			$donors = Donor::where('contact','LIKE','%'.$query.'%')->get();
			
			return view('ajax.donors-info', compact('donors'));
		
    }

    
	
	

}
