@extends('admin.includes.base')
@section('content')
<!-- ============================================================== -->
<!-- Page wrapper  -->
<!-- ============================================================== -->
<div class="page-wrapper">
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Deposit Slip</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
              <li class="breadcrumb-item"> <a href="{{ url('admin/home') }}">Home</a> </li>
              <li class="breadcrumb-item active" aria-current="page">Deposit Slip</li>
            </ol>
          </nav>
        </div>
      </div>
    </div>
  </div>
  <div class="container-fluid">
    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
      <div class="col-md-8">
        <div class="card card-body printableArea">
          <h3 class="text-right"><b>Sr. No.</b> <span>{{ $deposit->serial_no }}</span></h3>
          <hr>
          <div class="row">
            <div class="col-md-7">
              <div class="pull-left">
                <address>
                <p><strong>Credit Account Of:</strong></p>
                <ul class="list-unstyled">
                  <li class="media"> <img class="d-flex mr-3" src="https://donation.gnfb.ca/admin_assets/images/logo_new.png" width="60" alt="Generic placeholder image">
                    <div class="media-body">
                      <h5 class="mt-0 mb-1">Guru Nanak Modi Khana Food Bank Society</h5>
                      UNIT 101, 15199 - 68 AVE SURREY, BC V3S 2C1 <br />
                      <!--A/C No.: 92740 004 0024 5259957--> </div>
                  </li>
                  <li class="media mt-3">
                    <div class="media-body">
                      <h5 class="mt-0 mb-1">Date: {{ date('d/m/Y',strtotime($deposit->created_at)) }}</h5>
                    </div>
                  </li>
                  <li class="media">
                    <div class="media-body">
                      <h5 class="mt-0 mb-1">Account No: {{ $deposit->account_number }}</h5>
                    </div>
                  </li>
                </ul>
                </address>
              </div>
            </div>
            <div class="col-md-5">
              <div class="pull-right text-right">
                <address>
                <p><strong>Current Account Deposit Slip:</strong></p>
                <ul class="list-unstyled">
                  @if($deposit->bank_type=='Canada Trust')
                  <li class="media">
                    <div class="media-body">
                      <h5 class="mt-0 mb-1">Canada Trust</h5>
                      CEDAR Hills Plaza 12896 96th AVE Surrey, BC V3V6A8 </div>
                    <img class="d-flex ml-3" src="{{ url('admin_assets/images/canada-trust.png') }}" width="60" alt="Generic placeholder image"> </li>
                  @else
                  <li class="media">
                    <div class="media-body">
                      <h5 class="mt-0 mb-1">Khalsa Credit Union</h5>
						Unit 102, 7288 137th Street Surrey, BC V3W1A3 </div>
                    <img class="d-flex ml-3" src="{{ url('admin_assets/images/khalsa-credit.png') }}" width="60" alt="Generic placeholder image"> </li>
                  @endif
                </ul>
                </address>
              </div>
            </div>
            <div class="col-md-6">
              <div class="table-responsive m-t-10" style="clear: both;"> @php
                $cash_type = explode(',',$deposit->cash_type);
                $cash_amount = explode(',',$deposit->cash_amount);
                $cash_count = explode(',',$deposit->cash_count);
                @endphp
                <h4>CASH COUNT</h4>
                <table class="table table-bordered table-hover">
				<tr>
                    <td class="text-center"></td>
                    <td>Count</td>
                    <td class="text-right">Total</td>
                  </tr>
                  @for($i=0; $i <count($cash_type); $i++)
                  <tr>
                    <td class="text-center">{{ $cash_type[$i] }}</td>
                    <td class="text-right">{{ (!empty($cash_count[$i])) ? $cash_count[$i] : '' }}</td>
					<td>{{ (!empty($cash_amount[$i])) ? currency().$cash_amount[$i] : '' }}</td>
                  </tr>
                  @endfor
				  <tr>
                    <td class="text-center"></td>
                    <td class="text-right">Cash Subtotal</td>
					<td>{{ ($deposit->cash_subtotal) ? currency().$deposit->cash_subtotal : '' }}</td>
                  </tr>
                </table>
              </div>
            </div>
			<div class="col-md-6">
              <div class="table-responsive m-t-10" style="clear: both;"> @php
                $cheque_nos = explode(',',$deposit->cheque_nos);
                $cheque_amounts = explode(',',$deposit->cheque_amounts);
                @endphp
                <h4>CHEQUE COUNT</h4>
                <table class="table table-bordered table-hover">
				<tr>
                    <td>Cheque Details</td>
                    <td class="text-right">Amount</td>
                  </tr>
				  @if(!empty($deposit->cheque_nos))
                  @for($i=0; $i <count($cheque_nos); $i++)
                  <tr>
                    <td class="text-center">{{ $cheque_nos[$i] }}</td>
                    <td>{{ ($cheque_amounts[$i]) ? currency().$cheque_amounts[$i] : '' }}</td>
                  </tr>
                  @endfor
				  @else
				  <tr>
                    <td class="text-center">-</td>
                    <td>-</td>
                  </tr>
				  @endif
				  <tr>
                    <td class="text-right">Total No. of Cheques</td>
					<td>{{ (!empty($deposit->cheque_nos)) ? count($cheque_nos) : '0' }}</td>
                  </tr>
				  <tr>
                    <td class="text-right">Cheque Subtotal</td>
					<td>{{ ($deposit->cheque_subtotal) ? currency().$deposit->cheque_subtotal : '' }}</td>
                  </tr>
                </table>
              </div>
            </div>
            <div class="col-md-12">
			<div class="row">
			<div class="col-md-6">
              <!--<h4>DEPOSIT</h4>-->
              <div class="pull-left m-t-10"> <!--@if(!empty($deposit->cash_subtotal))
                <h4>Cash Subtotal: <strong>{{ ($deposit->cash_subtotal) ? currency().$deposit->cash_subtotal : '' }}</strong></h4>
                @endif
                @if(!empty($deposit->cheque_subtotal))
                <h4>Cheque Subtotal: <strong>{{ ($deposit->cheque_subtotal) ? currency().$deposit->cheque_subtotal : '' }}</strong></h4>
                @endif-->				
                
                <h3><b>Deposit Total :</b> {{ ($deposit->deposit_total) ? currency().$deposit->deposit_total : '' }}</h3>
              </div>
			  
			  </div>
			  <div class="col-md-6">
              <h4>NOTES</h4>
			  <p>{{ ($deposit->notes) ? $deposit->notes : '-' }}</p>
			  </div>
			  </div>
			  
			  
			  
              <div class="clearfix"></div>
              <hr>
              <div class="text-right">
                <button id="print" class="btn btn-default btn-outline" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- ============================================================== -->
    <!-- End PAge Content -->
    <!-- ============================================================== -->
  </div>
</div>
<!-- ============================================================== -->
<!-- End Page wrapper  -->
<!-- ============================================================== -->
@endsection 

@push('scripts')
<!-- This Page JS -->
<script src="{{ asset('dist/js/pages/samplepages/jquery.PrintArea.js') }}"></script>
<script>
    $(function() {
        $("#print").click(function() {
		toastr.options =
        {
            "closeButton" : true,
            "progressBar" : true,
			"positionClass" : "toast-top-center",
			"debug": true
        }
		toastr.success("test");
            /*var mode = 'iframe'; //popup
            var close = mode == "popup";
            var options = {
                mode: mode,
                popClose: close
            };
            $("div.printableArea").printArea(options);*/
        });
    });
    </script>
@endpush