@extends('admin.includes.base')
@section('content')
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Accounting</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="{{ url('admin/home') }}">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Accounting</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  @include('common.notify')
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card bg-light">
          <div class="card-body">
            <form method="get" action="{{ route('admin.accounting.index') }}">
              <div class="row">
                <div class="col-md-4">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Employee<span class="asterrisk">*</span></label>
                    <div class="clearfix"></div>
                    <select class="form-control" id="select2-employee" name="employee" style="width:100%;" required>
                      <option value="">--Select--</option>
                      <option value="All" @if(Request::has('employee')) @if(Request::get('employee')=='All') selected="selected" @endif @endif>All</option>
                      
					  @if(!empty($employees))
					  @foreach($employees as $employee)
                    
                      
                      <option value="{{ $employee->id }}" @if(Request::has('employee')) @if(Request::get('employee')==$employee->id) selected="selected" @endif @endif>{{ '#'.$employee->id.' - '.$employee->name }}
                      </option>
                      
                      
                    
                    
					  @endforeach
					  @endif
                    
                  
                  
                    
                    </select>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">From - To<span class="asterrisk">*</span></label>
                    <div class="clearfix"></div>
                    <div class='input-group mb-3'>
                      <input type='text' class="form-control daterange" name="daterange" required @if(Request::has('daterange')) value="{{ Request::get('daterange') }}" @else {{ date('Y-m-d',strtotime('-7 days')).' - '.date('Y-m-d') }} @endif autocomplete="off"/>
                      <div class="input-group-append"> <span class="input-group-text"> <span class="ti-calendar"></span> </span> </div>
                    </div>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">&nbsp;</label>
                    <div class='input-group mb-3'>
                      <button type="submit" class="btn btn-success"><i class="ti-filter"></i> Filter</button>
                    </div>
                  </div>
                </div>
              </div>
            </form>
            @if(Request::has('employee') && Request::has('daterange'))
            @if(!empty($reports))
            <div class="table-responsive">
              <table class="table bg-white table-bordered nowrap display">
                <thead>
                  <tr>
                    <th><input type="checkbox" id="checkAll"></th>
                    <th>Receipt ID</th>
                    <th>Donor Name</th>
                    <th>Donor Contact</th>
                    <th>Amount</th>
                    <th>Payment Method</th>
                    <th>Payment Status</th>
                    <th>Collected By</th>
                    <th>Donated On</th>
                  </tr>
                </thead>
                <tbody>
                
                @foreach($reports as $index => $receipt)
                <tr>
                  <td><input type="checkbox" class="checkbox" value="{{ $receipt->id }}" data-amount="{{ $receipt->amount }}"></td>
                  <td>{{ $receipt->receipt_no }}</td>
                  @if(!empty($receipt->donorInfo))
                  <td>{{ $receipt->donorInfo->first_name.' '.$receipt->donorInfo->last_name }}</td>
                  <td>{{ $receipt->donorInfo->contact }}</td>
                  @else
                  <td>-</td>
                  <td>-</td>
                  @endif
                  <td>$ {{ $receipt->amount }}</td>
                  <td>{{ $receipt->payment_mode }}</td>
                  <td>@if($receipt->payment_status=='Paid') <span class="label label-success">Paid
                    </label>
                    @else <span class="label label-danger">Not Paid
                    </label>
                    @endif</td>
                  <td>{{ $receipt->adminInfo->name }}</td>
                  <td>{{ date('d/m/Y',strtotime($receipt->created_at)) }}</td>
                </tr>
                @endforeach
                </tbody>
                
              </table>
            </div>
			<div class="updateBatchDiv" style="display:none;">
            <div class="row">
              <div class="col-md-6"></div>
              <div class="col-md-6">
                <div class="card">
				<form id="form" method="POST">
				{{csrf_field()}}
                  <div class="card-body">
                    <h4 class="card-title">Update Batch Status</h4>
                    <div class="card-text">
                      <div class="row">
                        <div class="col-6">
                          <div class="form-group">
                            <label for="inputEmail3" class="control-label col-form-label">Total Amount<span class="asterrisk">*</span></label>
                            <input class="form-control" type="text" value="{{ old('total') }}" name="total" id="total" placeholder="Total Amount" readonly="readonly">
							<span class="help-block" id="totalError"></span>
                          </div>
                        </div>
                        <div class="col-6">
                          <div class="form-group">
                            <label for="inputEmail3" class="control-label col-form-label">Updated By<span class="asterrisk">*</span></label>
                            <input class="form-control" type="text" value="{{ Auth::guard('admin')->user()->name }}" name="updated_by" id="contact" placeholder="Updated By" readonly="readonly">
							<span class="help-block" id="updated_byError"></span>
                          </div>
                        </div>
						<div class="col-12">
						
						<div class="form-group">
                            <label for="inputEmail3" class="control-label col-form-label">Note</label>
                            <input class="form-control" type="text" value="{{ old('note') }}" name="note" id="note" placeholder="Note">
							<span class="help-block" id="noteError"></span>
                          </div>
						</div>
                      </div>
                    </div>
                    <button type="button" class="btn btn-info" id="ajaxSubmit">Close Batch</button>
                  </div>
				  </form>
                </div>
              </div>
            </div>
			</div>
            @endif
            @endif </div>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection

@push('scripts')
<!--<script>
$(document).ready(function()
{
$("#checkAll").click(function () {
     $('input:checkbox').not(this).prop('checked', this.checked);
	 
	 if()
	 
 });
 });
</script>-->


<script type="text/javascript">
function calculateAmount(){
var amount = parseFloat('0.0');
$('.checkbox').each(function(){
      if ($(this).is(':checked')) {
	  var pamount = $(this).attr('data-amount');
	  amount += parseFloat(pamount);
	  }
});
$('#total').val(amount.toFixed(2));
}
$(document).ready(function(){
    $('#checkAll').on('click',function(){
        if(this.checked){
            $('.checkbox').each(function(){
                this.checked = true;
				$('.updateBatchDiv').css('display','block');
            });
        }else{
             $('.checkbox').each(function(){
                this.checked = false;
				$('.updateBatchDiv').css('display','none');
            });
        }
		calculateAmount();
    });
    
    $('.checkbox').on('click',function(){
        if($('.checkbox:checked').length == $('.checkbox').length){
            $('#checkAll').prop('checked',true);
			
        }else{
            $('#checkAll').prop('checked',false);
			$('.updateBatchDiv').css('display','none');
        }
		if($('.checkbox:checked').length>0)
		{
		$('.updateBatchDiv').css('display','block');
		}
		else
		{
		$('.updateBatchDiv').css('display','none');
		}
		calculateAmount();
    });
});
</script>

<script>

         $(document).ready(function(){
		 
            $('#ajaxSubmit').click(function(e){
			var btn = $(this);
			var old_html = btn.html();
			btn.html('Please wait...');
            btn.attr('disabled', true);
			
			$('#form span.help-block').text(' ');
			
			var myObject = new Object();
			var other_data = $('#form').serializeArray();
			$.each(other_data,function(key,input){
				myObject[input.name] = input.value;
			});
			
			myObject['check_list'] = $.map($('.checkbox:checked'), function(c){return c.value; }).join(',');
			
			//alert(JSON.stringify(myObject));
			
			
               e.preventDefault();
               $.ajaxSetup({
                  headers: {
                      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                  }
              });
			 
			  
			  var url = "{{route('admin.accounting.store')}}";
			  var method = 'post';
			  
			  //alert(url+" "+method);
               jQuery.ajax({
                  url: url,
                  method: method,   				  
				  data: myObject,
                  success: function(result){
				  //alert(JSON.stringify(result));
				  //alert('title='+result.responseJSON.errors.title);
                  	if(result.errors)
                  	{
                  		//jQuery('.alert-danger').html('');

                  		jQuery.each(result.errors, function(key, value){
							//alert(key);
                  			//jQuery('.alert-danger').show();
                  			//jQuery('.alert-danger').append('<li>'+value+'</li>');
							jQuery('#'+key+'Error').text(value);
                  		});
                  	}
                  	else
                  	{
                  		//jQuery('.alert-success').show();
						//jQuery('.alert-success').text(result.message);
						toastr.success(result.message);
						
						// redirect to google after 5 seconds
						window.setTimeout(function() {
							window.location.href = "{{ url('admin/accounting/history') }}";
						}, 2000);
						
                  		
                  	}
					btn.html(old_html);
                    btn.attr('disabled', false);
                  },
				  error: function(err){
				  	alert(JSON.stringify(err));
				  }  
				  });
               });			   
			   
            });
      </script>
@endpush