@extends('admin.includes.base')
@section('content')
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Donors</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="{{ url('admin/home') }}">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Donors</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  @include('common.notify')
  <div class="container-fluid">
    <div class="row">
      <div class="col-8">
        <div class="card">
          <div class="card-body padd-10">
            <div class="row">
              <div class="col-6">
                <h4 class="card-title pull-left">Update Donor</h4>
              </div>
              <div class="col-6 pull-right"> <a href="{{ route('admin.donor.index') }}" class="" style="float:right;"><i class="fa fa-angle-left"></i> Back</a> </div>
            </div>
          </div>
          <hr class="m-t-0">
          <form class="form-horizontal" action="{{route('admin.donor.update', $employee->id )}}" method="POST" enctype="multipart/form-data" role="form">
            {{csrf_field()}}
            <input type="hidden" name="_method" value="PATCH">
			<div class="card-body bg-light">
              <div class="row">
                <div class="col-8">
                  <div class="row">
                    <div class="col-6">
                      <div class="form-group">
                        <label for="inputEmail3" class="control-label col-form-label">First Name<span class="asterrisk">*</span></label>
                        <input type="text" class="form-control" id="inputEmail3" name="first_name" value="{{ $employee->first_name }}">
						@if ($errors->has('first_name')) <span class="help-block"> <strong>{{ $errors->first('first_name') }}</strong> </span> @endif
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="form-group">
                        <label for="inputEmail3" class="control-label col-form-label">Last Name<span class="asterrisk">*</span></label>
                        <input type="text" class="form-control" id="inputEmail3" name="last_name" value="{{ $employee->last_name }}">
						@if ($errors->has('last_name')) <span class="help-block"> <strong>{{ $errors->first('last_name') }}</strong> </span> @endif
                      </div>
                    </div>
                  </div>
                </div>
                <div class="col-4">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Contact Number<span class="asterrisk">*</span></label>
                    <input type="text" class="form-control" id="inputEmail3" name="contact" value="{{ $employee->contact }}">
					@if ($errors->has('contact')) <span class="help-block"> <strong>{{ $errors->first('contact') }}</strong> </span> @endif
                  </div>
                </div>
                <div class="col-6">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Address<span class="asterrisk">*</span></label>
                    <textarea class="form-control" id="inputEmail3" name="address">{{ $employee->address }}</textarea>
					@if ($errors->has('address')) <span class="help-block"> <strong>{{ $errors->first('address') }}</strong> </span> @endif
                  </div>
                </div>
                <div class="col-6">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Postal Code<span class="asterrisk">*</span></label>
                    <input type="text" class="form-control" id="inputEmail3" name="postal_code" value="{{ $employee->postal_code }}">
					@if ($errors->has('postal_code')) <span class="help-block"> <strong>{{ $errors->first('postal_code') }}</strong> </span> @endif
                  </div>
                </div>
              </div>
            </div>
            <div class="card-body">
              <div class="form-group m-b-0 text-right">
                <button type="submit" class="btn btn-info waves-effect waves-light">Save</button>
                <a href="{{route('admin.donor.index')}}" class="btn btn-dark waves-effect waves-light deactive_button">Cancel</a> </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection