@push('styles')
<style>
.pac-container { z-index: 100000!important; }
</style>
@endpush
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel1" data-backdrop="static" data-keyboard="false">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title" id="exampleModalLabel1">New Donation User</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      </div>
      <div class="modal-body">
        <form class="form-horizontal r-separator" action="{{route('admin.donor.store')}}" method="POST" enctype="multipart/form-data" role="form" id="form">
          {{csrf_field()}}
		  <input type="hidden" name="donor_id" value="" />
          <div class="card-body bg-light">
            <div class="row">
              <div class="col-sm-12 col-md-8">
                <div class="row">
                  <div class="col-6">
                    <div class="form-group">
                      <label for="inputEmail3" class="control-label col-form-label">First Name<span class="asterrisk">*</span></label>
                      <input type="text" class="form-control" id="inputEmail3" name="first_name" value="{{ old('first_name') }}" autocomplete="off">
                      <span class="help-block" id="first_nameError"></span> </div>
                  </div>
                  <div class="col-6">
                    <div class="form-group">
                      <label for="inputEmail3" class="control-label col-form-label">Last Name<span class="asterrisk">*</span></label>
                      <input type="text" class="form-control" id="inputEmail3" name="last_name" value="{{ old('last_name') }}" autocomplete="off">
                      <span class="help-block" id="last_nameError"></span> </div>
                  </div>
                </div>
              </div>
              <div class="col-sm-12 col-md-4">
                <div class="form-group">
                  <label for="inputEmail3" class="control-label col-form-label">Email Address<span class="asterrisk">*</span></label>
                  <input type="email" class="form-control" id="inputEmail3" name="email" value="{{ old('email') }}" autocomplete="off">
                  <span class="help-block" id="emailError"></span> </div>
              </div>
              <div class="col-sm-12 col-md-6">
                <div class="form-group">
                  <label for="inputEmail3" class="control-label col-form-label">Contact Number<span class="asterrisk">*</span></label>
                  <div class="row">
                    <div class="col-4">
                      <select class="form-control" name="contact_type">
                        <option value="Cell" @if(old('contact_type')=='Cell') selected="selected" @endif>Cell</option>
                        <option value="Home" @if(old('contact_type')=='Home') selected="selected" @endif>Home</option>
                        <option value="Office" @if(old('contact_type')=='Office') selected="selected" @endif>Office</option>
                      </select>
                      <span class="help-block" id="contact_typeError"></span> </div>
                    <div class="phone-div col-8">
                      <input type="hidden" name="country_code" class="country_code" value="{{ old('country_code') ?? '1' }}"/>
                      <input type="text" class="form-control phone" id="phone" name="contact" value="{{ old('contact') }}" autocomplete="off">
                      <span class="help-block" id="contactError"></span> </div>
                  </div>
                </div>
              </div>
              <div class="col-sm-12 col-md-6">
                <div class="form-group">
                  <label for="inputEmail3" class="control-label col-form-label">Alternate Contact Number</label>
                  <div class="row">
                    <div class="col-4">
                      <select class="form-control" name="alternate_contact_type">
					  <option value="Home" @if(old('alternate_contact_type')=='Home') selected="selected" @endif>Home</option>
                        <option value="Cell" @if(old('alternate_contact_type')=='Cell') selected="selected" @endif>Cell</option>
                        
                        <option value="Office" @if(old('alternate_contact_type')=='Office') selected="selected" @endif>Office</option>
                      </select>
                      <span class="help-block" id="alternate_contact_typeError"></span> </div>
                    <div class="phone-div col-8">
                      <input type="hidden" name="alternate_country_code" class="country_code" value="{{ old('alternate_country_code') ?? '1' }}"/>
                      <input type="text" class="form-control phone" id="phone" name="alternate_contact" value="{{ old('alternate_contact') }}" autocomplete="off">
                      <span class="help-block" id="alternate_contactError"></span> </div>
                  </div>
                </div>
              </div>
              <div class="col-sm-12 col-md-6">
                <div class="form-group">
                  <label for="inputEmail3" class="control-label col-form-label">Address<span class="asterrisk">*</span></label>
                  <input id="autocomplete" placeholder="Enter Address" type="text" class="form-control" name="address" value="{{ old('address') }}" autocomplete="off">
                  <!--<textarea class="form-control" id="inputEmail3" name="address">{{ old('address') }}</textarea>-->
                  <span class="help-block" id="addressError"></span> </div>
              </div>
			  <div class="col-sm-12 col-md-6">
			  </div>
			 
              <div class="row col-12" id="address">
      
         <div class="col-6">
            <label class="control-label col-form-label">Street address</label>
            <input class="form-control" id="street_number" name="street_number" value="{{ old('street_number') }}" autocomplete="off">
			<span class="help-block" id="street_numberError"></span>
         </div>
         <div class="col-6">
            <label class="control-label col-form-label">Route</label>
            <input class="form-control" id="route" name="street_route" value="{{ old('street_route') }}" autocomplete="off">
			<span class="help-block" id="street_routeError"></span>
         </div>
      
         <div class="col-6">
            <label class="control-label col-form-label">City</label>
            <input class="form-control field" id="locality" name="city" value="{{ old('city') }}" autocomplete="off">
			<span class="help-block" id="cityError"></span>
         </div>
         <div class="col-6"> 
            <label class="control-label col-form-label">State</label>
            <input class="form-control" id="administrative_area_level_1" name="state" value="{{ old('state') }}" autocomplete="off">
			<span class="help-block" id="stateError"></span>
         </div>
      
         <div class="col-6">
            <label class="control-label col-form-label">Postal Code<span class="asterrisk">*</span></label>
            <input class="form-control" id="postal_code" name="postal_code" value="{{ old('postal_code') }}" autocomplete="off">
			<span class="help-block" id="postal_codeError"></span>
         </div>
         <div class="col-6">
            <label class="control-label col-form-label">Country<span class="asterrisk">*</span></label>
            <input class="form-control" id="country" name="country" value="{{ old('country') }}" autocomplete="off">
			<span class="help-block" id="countryError"></span>
         </div>
      
   </div>
              <!--<div class="col-6">
                <div class="form-group">
                  <label for="inputEmail3" class="control-label col-form-label">Postal Code<span class="asterrisk">*</span></label>
                  <input type="text" class="form-control" id="postal_code" name="postal_code" value="{{ old('postal_code') }}">
                  <span class="help-block" id="postal_codeError"></span> </div>
              </div>-->
			  
            </div>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-primary" id="ajaxSubmit">Save Donation User</button>
      </div>
    </div>
  </div>
</div>
<!-- /.modal -->
@push('scripts')
<script>

         $(document).ready(function(){
		 
            $('#ajaxSubmit').click(function(e){
			var btn = $(this);
			var old_html = btn.html();
			btn.html('Please wait...');
            btn.attr('disabled', true);
			
			$('#form span.help-block').text(' ');
			
			var myObject = new Object();
			var other_data = $('#form').serializeArray();
			$.each(other_data,function(key,input){
				myObject[input.name] = input.value;
			});
			
               e.preventDefault();
               $.ajaxSetup({
                  headers: {
                      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                  }
              });
			  var donor_id = $('input[name="donor_id"]').val();
			  if(donor_id!='')
			  {
			  var url = "{{ url('/')}}/admin/donor/"+donor_id;
			  var method = 'PATCH';
			  }
			  else
			  {
			  var url = "{{route('admin.donor.store')}}";
			  var method = 'post';
			  }
			  //alert(url+" "+method);
               jQuery.ajax({
                  url: url,
                  method: method,   				  
				  data: myObject,
                  success: function(result){
				  //alert(JSON.stringify(result));
				  //alert('title='+result.responseJSON.errors.title);
                  	if(result.errors)
                  	{
                  		//jQuery('.alert-danger').html('');

                  		jQuery.each(result.errors, function(key, value){
							//alert(key);
                  			//jQuery('.alert-danger').show();
                  			//jQuery('.alert-danger').append('<li>'+value+'</li>');
							jQuery('#'+key+'Error').text(value);
                  		});
                  	}
                  	else
                  	{
                  		//jQuery('.alert-success').show();
						//jQuery('.alert-success').text(result.message);
						toastr.success(result.message);
						var donor_id = result.donor_id;					
						@if(Auth::guard('admin')->user()->utype=='Staff')
						// redirect to google after 5 seconds
						window.setTimeout(function() {
							$('#open').hide();
                  			$('#myModal').modal('hide');
							window.location.href = "{{ ($module=='donor') ? url('admin/donor') : url('admin/home') }}"+"?donor_id="+donor_id;
						}, 2000);
						@else
						// redirect to google after 5 seconds
						window.setTimeout(function() {
							$('#open').hide();
                  			$('#myModal').modal('hide');
							window.location.href = "{{ ($module=='donor') ? url('admin/donor') : url('admin/receipt/create') }}"+"?donor_id="+donor_id;;
						}, 2000);
						@endif
                  		
                  	}
					btn.html(old_html);
                    btn.attr('disabled', false);
                  },
				  error: function(err){
				  //alert(JSON.stringify(err));
				  }  
				  });
               });
			   
			   
			   /*Load Model Popup*/
			   
			   $('body').on('click', '.addRecord', function (event) {
					$('#form').trigger('reset');
					$('.modal-title').text("Add Donor");
					$('#ajaxSubmit').text("Add");
					$('#myModal').modal('show');
				});
				
				$('body').on('click', '.editRecord', function (event) {

					event.preventDefault();
					var id = $(this).data('id');
					//alert(id)
					$.get('donor/'+id+'/edit', function (data) {
						//alert(JSON.stringify(data));
						//alert(data.success);
						var success = data.success;
						if(success==1)
						{
						$('input[name="donor_id"]').val(data.donor.id);
						$('input[name="first_name"]').val(data.donor.first_name);
						$('input[name="last_name"]').val(data.donor.last_name);
						$('input[name="email"]').val(data.donor.email);
						$('input[name="contact_type"]').val(data.donor.contact_type);
						$('input[name="country_code"]').val(data.donor.country_code);
						$('input[name="contact"]').val(data.donor.contact);
						$('input[name="alternate_contact_type"]').val(data.donor.alternate_contact_type);
						$('input[name="alternate_country_code"]').val(data.donor.alternate_country_code);
						$('input[name="alternate_contact"]').val(data.donor.alternate_contact);
						$('input[name="address"]').val(data.donor.address);
						$('input[name="postal_code"]').val(data.donor.postal_code);
						$('.modal-title').text("Edit Donor");
						$('#ajaxSubmit').text("Update");
						$('#myModal').modal('show');
						}
					 });
				});
			   
			   /*Load Model Popup*/
			   
			   
            });
      </script>

<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAWjv_B5Ug9dxwMc9ig9dr1AjReKMvjZxE&libraries=places&callback=initAutocomplete" async defer></script>
<script type="text/javascript">//<![CDATA[


var placeSearch, autocomplete;
      var componentForm = {
        street_number: 'short_name',
        route: 'long_name',
        locality: 'long_name',
        administrative_area_level_1: 'short_name',
        country: 'long_name',
        postal_code: 'short_name'
      };

      function initAutocomplete() {
        // Create the autocomplete object, restricting the search to geographical
        // location types.
        autocomplete = new google.maps.places.Autocomplete(
            /** @type {!HTMLInputElement} */(document.getElementById('autocomplete')),
            {types: ['geocode']});

        // When the user selects an address from the dropdown, populate the address
        // fields in the form.
        autocomplete.addListener('place_changed', fillInAddress);
      }

      function fillInAddress() {
        // Get the place details from the autocomplete object.
        var place = autocomplete.getPlace();

        for (var component in componentForm) {
          document.getElementById(component).value = '';
          document.getElementById(component).disabled = false;
        }

        // Get each component of the address from the place details
        // and fill the corresponding field on the form.
        for (var i = 0; i < place.address_components.length; i++) {
          var addressType = place.address_components[i].types[0];
          if (componentForm[addressType]) {
            var val = place.address_components[i][componentForm[addressType]];
            document.getElementById(addressType).value = val;
          }
        }
      }

      // Bias the autocomplete object to the user's geographical location,
      // as supplied by the browser's 'navigator.geolocation' object.
      /*function geolocate() {
        if (navigator.geolocation) {
          navigator.geolocation.getCurrentPosition(function(position) {
            var geolocation = {
              lat: position.coords.latitude,
              lng: position.coords.longitude
            };
            var circle = new google.maps.Circle({
              center: geolocation,
              radius: position.coords.accuracy
            });
            autocomplete.setBounds(circle.getBounds());
          });
        }
      }*/


  //]]></script>	  
@endpush