@extends('admin.includes.base')
@push('styles')
<style>
.modal-content .card-body {
    padding: 10px 10px 0px;
}
</style>
@endpush
@section('content')
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Receipts</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="{{ url('admin/home') }}">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Receipts</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  @include('common.notify')
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card bg-light">
          <div class="card-body">
            <div class="d-flex m-b-30 no-block">
              <h5 class="card-title m-b-0 align-self-center">View Donations</h5>
              <div class="ml-auto">
                <div class="dl">
                  <div class="col-3 align-self-center"> <a class="btn btn-primary" href="{{ url('admin/home') }}">New Receipt</a> </div>
                </div>
              </div>
            </div>
			<form method="get" action="{{ route('admin.receipt.staff') }}">
              <div class="row">
                <div class="col-md-2">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Receipt ID</label>
                    <div class="clearfix"></div>
                    <input type='text' class="form-control" name="receiptId" @if(Request::has('receiptId')) value="{{ Request::get('receiptId') }}" @endif autocomplete="off"/>
                  </div>
                </div>
                <div class="col-md-2">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Donor Name<span class="asterrisk">*</span></label>
                    <div class="clearfix"></div>
                    <input type='text' class="form-control" name="donorName" required @if(Request::has('donorName')) value="{{ Request::get('donorName') }}" @endif autocomplete="off"/>
                  </div>
                </div>
				<div class="col-md-3">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Donor Email ID</label>
                    <div class="clearfix"></div>
                    <input type='email' class="form-control" name="donorEmailId" @if(Request::has('donorEmailId')) value="{{ Request::get('donorEmailId') }}" @endif autocomplete="off"/>
                  </div>
                </div>
				<div class="col-md-3">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Donor Contact No</label>
                    <div class="clearfix"></div>
                    <input type='text' class="form-control" name="donorContactNo" @if(Request::has('donorContactNo')) value="{{ Request::get('donorContactNo') }}" @endif autocomplete="off"/>
                  </div>
                </div>
                <div class="col-md-2">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">&nbsp;</label>
                    <div class='input-group mb-3'>
                      <button type="submit" class="btn btn-success"><i class="ti-filter"></i> Search</button>
                    </div>
                  </div>
                </div>
              </div>
            </form>
			@if(Request::has('donorName'))
            <div class="table-responsive">
              <table class="table bg-white table-bordered nowrap display file_export">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Receipt ID</th>
                    <th>Donor Name</th>
                    <th>Donor Contact</th>
                    <th>Amount</th>
                    <th>Payment Method</th>
                    <th>Payment Status</th>
                    <th>Collected By</th>
					<th>Batch Status</th>
                    <th>Donated On</th>
                    <th class="noExport">Actions</th>
                  </tr>
                </thead>
                <tbody>
                
                @foreach($receipts as $index => $receipt)
                <tr>
                  <td>{{ $index + 1 }}</td>
                  <td>{{ $receipt->receipt_no }}</td>
                  @if(!empty($receipt->donorInfo))
                  <td>{{ $receipt->donorInfo->first_name.' '.$receipt->donorInfo->last_name }}</td>
                  <td>{{ $receipt->donorInfo->contact }}</td>
                  @else
                  <td>-</td>
                  <td>-</td>
                  @endif
                  <td>$ {{ $receipt->amount }}</td>
                  <td>{{ $receipt->payment_mode }}</td>
                  <td>@if($receipt->payment_status=='Paid') <span class="label label-success">Paid
              </span>
              @else <span class="label label-danger">Not Paid
              </span>
              @endif</td>
                  <td>{{ $receipt->adminInfo->name }}</td>
				  
				  <td>@if($receipt->batch_status=='Open') <span class="label label-success">Open
              </span>
              @else <span class="label label-danger">Closed
              </span>
              @endif</td>
				  
                  <td>{{ date('d/m/Y',strtotime($receipt->created_at)) }}</td>
                  <td>
				  <a href="{{ route('admin.receipt.print', $receipt->id) }}" class="btn btn-success btn-sm"><i class="fa fa-print"></i></a>
				  <a href="javascript:;" class="btn btn-info btn-sm receipt-details" data-id="{{ $receipt->id }}"><i class="fa fa-eye"></i></a></td>
                </tr>
                @endforeach
                </tbody>
                
              </table>
            </div>
			@endif
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel1">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title" id="exampleModalLabel1">Donation Details</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      </div>
      <div class="modal-body load-receipt-data"> </div>
    </div>
  </div>
</div>
@endsection

@push('scripts')
<script>

function loadReceiptDetails(receipt_id)
{
	$(".load-receipt-data").html('<img src="{{ asset('admin_assets/images/loader.gif') }}" width="100" height="100" class="image-center"/>');
	var data = {'_token': "<?php echo csrf_token() ?>", 'receipt_id': receipt_id};
	//alert(JSON.stringify(data));
			$.ajax({
               type: 'POST',
               url: '{{ url("ajax/receipt/loadReceiptData") }}',
               data: data,
               success:function(data){
                  $(".load-receipt-data").html(data);
				  $('#exampleModal').modal('show');
				    //alert(JSON.stringify(data));
               },
			   error: function(err)
			   {
			   		//alert(JSON.stringify(err));
			   }
            });	
}

function markPaid(receipt_id)
{
	$(".load-receipt-data").html('<img src="{{ asset('admin_assets/images/loader.gif') }}" width="100" height="100" class="image-center"/>');
	var data = {'_token': "<?php echo csrf_token() ?>", 'receipt_id': receipt_id};
	//alert(JSON.stringify(data));
			$.ajax({
               type: 'POST',
               url: '{{ url("ajax/receipt/markPaidReceipt") }}',
               data: data,
               success:function(data){
                  $(".load-receipt-data").html(data);
				  $('#exampleModal').modal('show');
				    //alert(JSON.stringify(data));
               },
			   error: function(err)
			   {
			   		//alert(JSON.stringify(err));
			   }
            });	
}


$(document).ready(function() {
$(document).on('click','.receipt-details',function() {
	var receipt_id = $(this).attr('data-id');
	//alert('customer='+receipt_id);
	loadReceiptDetails(receipt_id);
});

$(document).on('click','.mark-paid',function() {
	var receipt_id = $(this).attr('data-id');
	//alert('customer='+workorder_id);
	markPaid(receipt_id);
});
});
</script>
@endpush