@extends('admin.includes.base')
@section('content')
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Donation Reports</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="{{ url('admin/home') }}">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Donation Reports</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  @include('common.notify')
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card bg-light">
          <div class="card-body">
            <div class="d-flex m-b-30 no-block">
              <h5 class="card-title m-b-0 align-self-center">View Donation Reports</h5>
              <div class="ml-auto">
                <div class="dl">
                  <div class="col-3 align-self-center"> </div>
                </div>
              </div>
            </div>
            <form method="get" action="{{ route('admin.report.index') }}">
              <div class="row">
                <div class="col-md-4">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Customer<span class="asterrisk">*</span></label>
                    <div class="clearfix"></div>
                    <select class="form-control" id="select2-employee" name="customer" style="width:100%;" required>
                      <option value="">Select Customer</option>
                      
					  @if(!empty($customers))
					  @foreach($customers as $customer)
                    
                      <option value="{{ $customer->id }}" @if(Request::has('customer')) @if(Request::get('customer')==$customer->id) selected="selected" @endif @endif>{{ 'MSC'.$customer->id.' - '.$customer->first_name.' '.$customer->last_name }}</option>
                      
                    
                    
					  @endforeach
					  @endif
                    
                  
                  
                    </select>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">From - To<span class="asterrisk">*</span></label>
                    <div class="clearfix"></div>
                    <div class='input-group mb-3'>
                      <input type='text' class="form-control daterange" name="daterange" required @if(Request::has('daterange')) value="{{ Request::get('daterange') }}" @endif autocomplete="off"/>
                      <div class="input-group-append"> <span class="input-group-text"> <span class="ti-calendar"></span> </span> </div>
                    </div>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">&nbsp;</label>
                    <div class='input-group mb-3'>
                      <button type="submit" class="btn btn-success"><i class="ti-filter"></i> Filter</button>
                    </div>
                  </div>
                </div>
              </div>
            </form>
            @if(Request::has('customer') && Request::has('daterange'))
			@if(!empty($reports))
            <div class="table-responsive">
              <table class="table bg-white table-bordered nowrap display file_export">
                <thead>
                  <tr>
                    <th>Sr No.</th>
					<th>Work Order No.</th>
                    <th>Customer</th>
                    <th>Vehicle</th>
					<th>Order On</th>
					<th>Started On</th>
					<th>Completed On</th>
					<th>Total Hours</th>
					<th>Status</th>
                    <th class="noExport">Actions</th>
                  </tr>
                </thead>
                <tbody>
                @foreach($reports as $index => $order)
                <tr>
                  <td>{{ $index + 1 }}</td>
				  <td>#{{ $order->id }}</td>
                  <td>{{ $order->customerInfo->first_name.' '.$order->customerInfo->last_name }}</td>
                  <td>{{ $order->vehicleInfo->plate_no }}</td>
				  <td>{{ $order->created_at }}</td>
				  @if($order->status=='2')
				  <td>{{ $order->started_at }}</td>
				  <td>{{ $order->completed_at }}</td>
				  <td>{{ $order->total_hours }}</td>
				  @else
				  <td>-</td>
				  <td>-</td>
				  <td>-</td>
				  @endif
				  <td>
				  @if($order->status=='1')
				  <span class="label label-warning">In Progress</span>
				  @elseif($order->status=='2')
				  <span class="label label-success">Completed</span>
				  
				  @else
				  <span class="label label-danger">Pending</span>
				  @endif
				  </td>
                  <td>
					  <a href="{{ route('admin.workorder.print', $order->id) }}" class="btn btn-success btn-sm"><i class="fa fa-print"></i> Print</a></td>
                </tr>
                @endforeach
                </tbody>
                
              </table>
            </div>
			@endif
            @endif </div>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection