<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Helpers\Helper;

use Auth;
use Exception;
use \Carbon\Carbon;

use App\Models\Admin;
use App\Models\Receipt;
use App\Models\Donor;
use DB;
use App\Models\LoginActivity;

class AdminController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('admin');
    } 


    /**
     * Dashboard.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */
    public function dashboard()
    {
		$total_admins = Admin::where('id','!=','1')->count(); 
		$total_donors = Donor::count();
		
		$date1 = Carbon::parse(date('Y-m-d')); // 2015-07-02
		$datee = $date1->startOfWeek();
		//echo '<br>';echo '<br>';echo '<br>';echo '<br>';echo '<br>';echo '<br>';
		$m1 = $datee;
		//echo '<br>';
		$m2 = date('Y-m-d',strtotime($datee.'+1 day'));
		//echo '<br>';
		$m3 = date('Y-m-d',strtotime($datee.'+2 day'));
		//echo '<br>';
		$m4 = date('Y-m-d',strtotime($datee.'+3 day'));
		//echo '<br>';
		$m5 = date('Y-m-d',strtotime($datee.'+4 day'));
		//echo '<br>';
		$m6 = date('Y-m-d',strtotime($datee.'+5 day'));
		//echo '<br>';
		$m7 = date('Y-m-d',strtotime($datee.'+6 day'));
		//echo '<br>';
		
		if(Auth::guard('admin')->user()->utype=='Super' || Auth::guard('admin')->user()->utype=='Admin' || Auth::guard('admin')->user()->utype=='Treasury')
		{
		
		$total_receipts = Receipt::count();
		$total_amount = Receipt::sum('amount'); 
		$weekly_amount = '';
		
		
		
		//echo $date->addDays(4);
		$mon = Receipt::whereDate('created_at', $m1)->sum('amount');
		$tue = Receipt::whereDate('created_at', '=', $m2)->sum('amount');
		$wed = Receipt::whereDate('created_at', '=', $m3)->sum('amount');
		$thu = Receipt::whereDate('created_at', '=', $m4)->sum('amount');
		$fri = Receipt::whereDate('created_at', '=', $m5)->sum('amount');
		$sat = Receipt::whereDate('created_at', '=', $m6)->sum('amount');
		$sun = Receipt::whereDate('created_at', '=', $m7)->sum('amount');
		}
		else
		{
		$weekly_amount = Receipt::whereBetween('created_at', [Carbon::now()->startOfWeek(), Carbon::now()->endOfWeek()])->where('admin_id',Auth::guard('admin')->user()->id)->sum('amount');
		$total_receipts = Receipt::where('admin_id',Auth::guard('admin')->user()->id)->count();
		$total_amount = Receipt::where('admin_id',Auth::guard('admin')->user()->id)->sum('amount'); 
		
		
		
		
		//$date->addDays(4);
		
		$mon = Receipt::where('admin_id',Auth::guard('admin')->user()->id)->whereDate('created_at', $m1)->sum('amount');
		$tue = Receipt::where('admin_id',Auth::guard('admin')->user()->id)->whereDate('created_at', '=', $m2)->sum('amount');
		$wed = Receipt::where('admin_id',Auth::guard('admin')->user()->id)->whereDate('created_at', '=', $m3)->sum('amount');
		$thu = Receipt::where('admin_id',Auth::guard('admin')->user()->id)->whereDate('created_at', '=', $m4)->sum('amount');
		//echo $date->addDays(4);
		
		//DB::enableQueryLog();
		$fri = Receipt::where('admin_id',Auth::guard('admin')->user()->id)->whereDate('created_at', '=', $m5)->sum('amount');
		//dd(DB::getQueryLog());
		
		
		
		
		$sat = Receipt::where('admin_id',Auth::guard('admin')->user()->id)->whereDate('created_at', '=', $m6)->sum('amount');
		$sun = Receipt::where('admin_id',Auth::guard('admin')->user()->id)->whereDate('created_at', '=', $m7)->sum('amount');
		}
		
		$year = date('Y');
		
		$jan = Receipt::whereYear('created_at', $year)->whereMonth('created_at', '01')->sum('amount');
		$feb = Receipt::whereYear('created_at', $year)->whereMonth('created_at', '02')->sum('amount');
		$mar = Receipt::whereYear('created_at', $year)->whereMonth('created_at', '03')->sum('amount');
		$apr = Receipt::whereYear('created_at', $year)->whereMonth('created_at', '04')->sum('amount');
		$may = Receipt::whereYear('created_at', $year)->whereMonth('created_at', '05')->sum('amount');
		$jun = Receipt::whereYear('created_at', $year)->whereMonth('created_at', '06')->sum('amount');
		$jul = Receipt::whereYear('created_at', $year)->whereMonth('created_at', '07')->sum('amount');
		$aug = Receipt::whereYear('created_at', $year)->whereMonth('created_at', '08')->sum('amount');
		$sep = Receipt::whereYear('created_at', $year)->whereMonth('created_at', '09')->sum('amount');
		$oct = Receipt::whereYear('created_at', $year)->whereMonth('created_at', '10')->sum('amount');
		$nov = Receipt::whereYear('created_at', $year)->whereMonth('created_at', '11')->sum('amount');
		$dec = Receipt::whereYear('created_at', $year)->whereMonth('created_at', '12')->sum('amount');
		
		
		$bar_graph = array('jan'=>$jan,'feb'=>$feb,'mar'=>$mar,'apr'=>$apr,'may'=>$may,'jun'=>$jun,'jul'=>$jul,'aug'=>$aug,'sep'=>$sep,'oct'=>$oct,'nov'=>$nov,'dec'=>$dec);
		
		
		
		
		
		
		
		$chart_graph = array('mon'=>$mon,'tue'=>$tue,'wed'=>$wed,'thu'=>$thu,'fri'=>$fri,'sat'=>$sat,'sun'=>$sun);
		
		
		$donors = Donor::orderBy('created_at' , 'desc')->get();	
		$total_batches = Receipt::where('batch_status','Open')->count();
		
        return view('admin.dashboard', compact('total_admins','total_donors','total_receipts','total_amount','donors','weekly_amount','bar_graph','chart_graph','total_batches'));
    }

	public function history()
    {
		$activities = LoginActivity::where('admin_id',Auth::guard('admin')->user()->id)->orderBy('created_at','desc')->paginate(15);
        return view('admin.account.history',compact('activities'));
    }
    
    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */
    public function profile()
    {
        return view('admin.account.profile');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */
    public function profile_update(Request $request)
    {
        $this->validate($request,[
            'first_name' => 'required|max:255',
			'last_name' => 'required|max:255',
			'contact' => 'required|max:255',
            //'email' => 'required|max:255|email|unique:admins',
            'picture' => 'mimes:jpeg,jpg,bmp,png|max:5242880',
			'signature' => 'mimes:jpeg,jpg,bmp,png|max:5242880',
			//'about' => 'required',
        ]);

        try{
            $admin = Auth::guard('admin')->user();
            $admin->name = $request->first_name.' '.$request->last_name;
            //$admin->email = $request->email;
			$admin->contact = $request->contact;
			//$admin->about = $request->about;
            
            if($request->hasFile('picture')){
                $admin->picture = $request->picture->store('admin/profile');  
            }
			
			if($request->hasFile('signature')){
                $admin->signature = $request->signature->store('admin/profile');  
            }
			
			if(Auth::guard('admin')->user()->utype=="Super")
			{
				$admin->bank1 = $request->bank1;
				$admin->bank2 = $request->bank2;
			}
			
						
            $admin->save();

            return redirect()->back()->with('flash_success','Profile Updated');
        }

        catch (Exception $e) {
             return back()->with('flash_error','Something Went Wrong!');
        }
        
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */
    public function password()
    {
        return view('admin.account.change-password');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */
    public function password_update(Request $request)
    {

        $this->validate($request,[
            'old_password' => 'required',
            'password' => 'required|min:6|confirmed',
        ]);

        try {

           $Admin = Admin::find(Auth::guard('admin')->user()->id);

            if(password_verify($request->old_password, $Admin->password))
            {
                $Admin->password = bcrypt($request->password);
                $Admin->save();

                return redirect()->back()->with('flash_success','Password Updated');
            }
        } catch (Exception $e) {
             return back()->with('flash_error','Something Went Wrong!');
        }
    }


}
