<?php

namespace App\Http\Controllers\Resource;

use App\Models\Donor;
//use App\UserRequests;
use Illuminate\Http\Request;
use App\Helpers\Helper;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use App\Http\Controllers\Controller;
use Exception;
use Storage;
//use Setting;
use DB;
use App\Models\LoginActivity;
use App\Models\Donate;
use Illuminate\Http\Response;
use Validator;

class DonateResource extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('demo', ['only' => ['destroy']]);
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
	}

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.donate.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
	
		$validator = Validator::make($request->all(),[
			'donor_id' => 'required|max:255',
			'amount' => 'required|max:255'
        ]		
		);
		
		if ($validator->fails())
        {
            return response()->json(['errors'=>$validator->errors()->all()]);
			
			//return response()->json(['errors'=>$validator->getMessageBag()->toArray(),'donor_id'=>'']);
        }
		          
       try{
			$donate = $request->all();
			//$donate['status'] = '1';
			$donate = Donate::create($donate);

			
			\Stripe\Stripe::setApiKey(env('STRIPE_SECRET'));
			header('Content-Type: application/json');
			$amount = isset($request->amount) ? intval($request->amount)*100 : 1000;
			//$amount = 1000;
			$checkout_session = \Stripe\Checkout\Session::create([
									'payment_method_types' => ['card'],
									'mode' => 'payment',
									'line_items' => [[
										'price_data' => [
											'currency' => 'usd',
											'product_data' => [
												'name' => 'Donation',
											],
											'unit_amount' => $amount, // Amount in cents (e.g., 1000 = $10)
										],
										'quantity' => 1, // Quantity of the item
									]],
									'success_url' => url('admin/donate/success') . '?donate_id=' . $donate->id,
   	 								'cancel_url' => url('admin/donate/cancel') . '?donate_id=' . $donate->id,
								]);
								
			header("HTTP/1.1 303 See Other");
			header("Location: " . $checkout_session->url);


            //return back()->with('flash_success','Donor Details Saved Successfully');
			
        } 

        catch (Exception $e) {
            return back()->with('flash_error', 'Something went wrong. Please try again later');
        }	
		
		
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
	}

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
	}

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
	}

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
	}
	
	
	public function success(Request $request)
    {
        try {
			$employee = Donate::findOrFail($request->donate_id);
			$employee->payment_status = 'Success';
            $employee->save();
			
            return redirect()->route('admin.donate.create')->with('flash_success', 'Payment has been made successfully.');
        } 

        catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'Something went wrong. Please try again later.');
        }
    }
	
	public function cancel(Request $request)
    {
        try {
			$employee = Donate::findOrFail($request->donate_id);
			$employee->payment_status = 'Cancel';
            $employee->save();
			
            return redirect()->route('admin.donate.create')->with('flash_success', 'Payment has not been made successfully.');
        } 

        catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'Something went wrong. Please try again later.');
        }
    }
}
