<?php

namespace App\Http\Controllers\Resource;

use App\Models\Donor;
//use App\UserRequests;
use Illuminate\Http\Request;
use App\Helpers\Helper;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use App\Http\Controllers\Controller;
use Exception;
use Storage;
//use Setting;
use DB;
use App\Models\LoginActivity;
use Illuminate\Http\Response;
use Validator;

class DonorResource extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('demo', ['only' => ['destroy']]);
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
		$donors = Donor::orderBy('created_at' , 'desc')->get();		
        return view('admin.donor.index', compact('donors'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.donor.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
	
		$validator = Validator::make($request->all(),[
			'first_name' => 'required|max:255',
			'last_name' => 'required|max:255',
			'email' => 'required|email',
			'contact_type' => 'required|max:255',
			'country_code' => 'required|max:255',
			'contact' => 'required|max:255',
			'alternate_contact_type' => 'max:255',
			'alternate_country_code' => 'max:255',
			'alternate_contact' => 'max:255',
			'address' => 'required',
			'postal_code' => 'required',
			'country' => 'required'		
        ]		
		);
		
		if ($validator->fails())
        {
            //return response()->json(['errors'=>$validator->errors()->all()]);
			
			return response()->json(['errors'=>$validator->getMessageBag()->toArray(),'donor_id'=>'']);
        }
		          
        try{

            $donor = $request->all();
			$donor['status'] = '1';
			$donor = Donor::create($donor);

            //return back()->with('flash_success',translate('Donor Details Saved Successfully'));
			return response()->json(['message'=>'Donor Details Saved Successfully','donor_id'=>$donor->id]);

        } 

        catch (Exception $e) {
            //return back()->with('flash_error', translate('Something went wrong. Please try again later'));
			return response()->json(['message'=>'Something went wrong. Please try again later','donor_id'=>'']);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        try {
            $employee = Donor::findOrFail($id);
			$activities = LoginActivity::where('admin_id',$id)->orderBy('created_at','desc')->paginate(15);
            return view('admin.donor.details', compact('employee','activities'));
        } catch (ModelNotFoundException $e) {
            return $e;
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
		try {
			$donor = Donor::findOrFail($id);          
			
            //return view('admin.donor.edit',compact('customers','object'));
			
			return response()->json(['success' => '1','donor'=>$donor,'message'=>'']);
			
        } catch (ModelNotFoundException $e) {
            //return $e;
			return response()->json(['success' => '0','donor'=>'','message'=>'Something went wrong. Please try again later']);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
		$validator = Validator::make($request->all(),[
            'first_name' => 'required|max:255',
			'last_name' => 'required|max:255',
			'email' => 'required|email|unique:donors,id,'.$id,
			'contact_type' => 'required|max:255',
			'country_code' => 'required|max:255',
			'contact' => 'required|max:255',
			'alternate_contact_type' => 'required|max:255',
			'alternate_country_code' => 'required|max:255',
			'alternate_contact' => 'required|max:255',
			'address' => 'required',
			'postal_code' => 'required'	
        ]);
		
		if ($validator->fails())
        {
            //return response()->json(['errors'=>$validator->errors()->all()]);
			
			return response()->json(['errors'=>$validator->getMessageBag()->toArray()]);
        }

        try {

            $donor = Donor::findOrFail($id);
            $donor->first_name = $request->first_name;
			$donor->last_name = $request->last_name;
			$donor->email = $request->email;
			$donor->contact_type = $request->contact_type;
			$donor->country_code = $request->country_code;
			$donor->contact = $request->contact;
			$donor->alternate_contact_type = $request->alternate_contact_type;
			$donor->alternate_country_code = $request->alternate_country_code;
			$donor->alternate_contact = $request->alternate_contact;
			$donor->address = $request->address;
			$donor->postal_code = $request->postal_code;
            $donor->save();

            //return redirect()->route('admin.donor.edit', $id)->with('flash_success', translate('Donor information Updated Successfully'));   
			return response()->json(['message'=>'Donor information Updated Successfully']); 
        } 

        catch (ModelNotFoundException $e) {
            //return back()->with('flash_error', translate('Object Not Found'));
			return response()->json(['message'=>'Something went wrong. Please try again later'],200);
        }
	
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        
        try {

            Donor::find($id)->delete();
			
            return back()->with('message', 'Donor deleted successfully');
        } 
        catch (Exception $e) {
            return back()->with('flash_error', 'Donor Not Found');
        }
    }
	
	
	public function uptStatus($id,$status)
    {
        try {
			$employee = Donor::findOrFail($id);
			$employee->status = $status;
            $employee->save();
			
			$statusMsg = ($status=='1') ? 'Activated' : 'Inactivated';
			
            return redirect()->route('admin.donor.index')->with('flash_success', 'Donor Status has been '.$statusMsg);
        } 

        catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'Donor Not Found');
        }
    }
}
