<?php

namespace App\Http\Controllers\Resource;

use App\Models\Receipt;
//use App\UserRequests;
use Illuminate\Http\Request;
use App\Helpers\Helper;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use App\Http\Controllers\Controller;
use Exception;
use Storage;
//use Setting;
use DB;
use App\Models\Donor;
use Auth;
use PDF;
use Mail;
use App\Models\Transaction;
  

class ReceiptResource extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('demo', ['only' => ['destroy']]);
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {		
		$receipts = Receipt::with('adminInfo','donorInfo')->orderBy('created_at' , 'desc')->get();		
        return view('admin.receipt.index', compact('receipts'));
    }
	
	

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
		$donors = Donor::where('status','1')->orderBy('id','desc')->get();
        return view('admin.receipt.create',compact('donors'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
		$this->validate($request, [
				'donor_id' => 'required|max:255',
				'amount' => 'required|numeric|between:0,9999999999.99',
				'payment_mode' => 'required',
				
				'card_number' => 'required_if:payment_mode,Card',
				'expiry_month' => 'required_if:payment_mode,Card',
				'expiry_year' => 'required_if:payment_mode,Card',
				'cvv' => 'required_if:payment_mode,Card',
				
				'cheque_no' => 'required_if:payment_mode,Cheque',
				'cheque_date' => 'required_if:payment_mode,Cheque',
				
				'pledge_date' => 'required_if:payment_mode,Pledge',
				
				'payment_frequency' => 'required',
				'payment_status' => 'required',
				//'remarks' => 'required',
        	]);  
		
			
			
        try{ 
			$receipt = $request->all();
			$receipt['admin_id'] = Auth::guard('admin')->user()->id;
			$receipt['receipt_no'] = getReceiptNo();
			$receipt = Receipt::create($receipt);

            //return back()->with('flash_success','Receipt Details Saved Successfully'); 
			
			
			
			if($receipt->payment_mode=='Pledge')
			{
			if(Auth::guard('admin')->user()->utype=='Super')
			{
			return redirect()->route('admin.receipt.create')->with('flash_success', 'Receipt Details Saved Successfully');
			}
			else
			{
			return redirect()->to('admin')->with('flash_success', 'Receipt Details Saved Successfully');
			}
			}
			else
			{
			return redirect()->route('admin.receipt.print', $receipt->id)->with('flash_success', 'Receipt Details Saved Successfully');
			}
			
        } 

        catch (Exception $e) {
            return back()->withInput()->with('flash_error', 'Something went wrong. Please try again later');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        try {
            $employee = Receipt::findOrFail($id);
			$activities = LoginActivity::where('admin_id',$id)->orderBy('created_at','desc')->paginate(15);
            return view('admin.receipt.details', compact('employee','activities'));
        } catch (ModelNotFoundException $e) {
            return $e;
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $receipt = Receipt::findOrFail($id);
			$donorInfo = Donor::where('id',$receipt->donor_id)->first();
            return view('admin.receipt.edit',compact('receipt','donorInfo'));
        } catch (ModelNotFoundException $e) {
            return $e;
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            	'first_name' => 'required',
				'last_name' => 'required',
				'email' => 'required',
				'contact_type' => 'required',
				'contact' => 'required',
				/*'alternate_contact_type' => 'required',
				'alternate_contact' => 'required',*/
				'address' => 'required',
				/*'street_number' => 'required',
				'street_route' => 'required',
				'city' => 'required',
				'state' => 'required',*/
				'postal_code' => 'required',
				'country' => 'required',
				
				'amount' => 'required|numeric|between:0,9999999999.99',
				'payment_mode' => 'required',
				'card_number' => 'required_if:payment_mode,Card',
				'expiry_month' => 'required_if:payment_mode,Card',
				'expiry_year' => 'required_if:payment_mode,Card',
				'cvv' => 'required_if:payment_mode,Card',
				
				'cheque_no' => 'required_if:payment_mode,Cheque',
				'cheque_date' => 'required_if:payment_mode,Cheque',
				
				'pledge_date' => 'required_if:payment_mode,Pledge',
				
				'payment_frequency' => 'required',
				'payment_status' => 'required',
        ]);

        try {
			$receiptInfo = Receipt::findOrFail($id);
			$donorInfo = Donor::where('id',$receiptInfo->donor_id)->first();
			$donorInfo->first_name = $request->first_name;
			$donorInfo->last_name = $request->last_name;
			$donorInfo->email = $request->email;
			$donorInfo->contact_type = $request->contact_type;
			$donorInfo->contact = $request->contact;
			$donorInfo->alternate_contact_type = $request->alternate_contact_type;
			$donorInfo->alternate_contact = $request->alternate_contact;
			$donorInfo->address = $request->address;
			$donorInfo->street_number = $request->street_number;
			$donorInfo->street_route = $request->street_route;
			$donorInfo->city = $request->city;
			$donorInfo->state = $request->state;
			$donorInfo->postal_code = $request->postal_code;
			$donorInfo->country = $request->country;
			$donorInfo->save();
            
            $receiptInfo->amount = $request->amount;
			$receiptInfo->payment_mode = $request->payment_mode;
            $receiptInfo->card_number = $request->card_number;
			//$receiptInfo->expiry_month = $request->expiry_month;
			//$receiptInfo->expiry_year = $request->expiry_year;
			//$receiptInfo->cvv = $request->cvv;
			$receiptInfo->cheque_no = $request->cheque_no;
			$receiptInfo->cheque_date = $request->cheque_date;
			$receiptInfo->pledge_date = $request->pledge_date;
			$receiptInfo->payment_frequency = $request->payment_frequency;
			$receiptInfo->payment_status = $request->payment_status;
			
            $receiptInfo->save();

            return redirect()->route('admin.receipt.edit', $receiptInfo->id)->with('flash_success', 'Receipt Updated Successfully');    
        } 

        catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'Receipt Not Found');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        
        try {

            Receipt::find($id)->delete();
			
            return back()->with('message', 'Receipt deleted successfully');
        } 
        catch (Exception $e) {
            return back()->with('flash_error', 'Receipt Not Found');
        }
    }
	
	
	public function uptStatus($id,$status)
    {
        try {
			$employee = Receipt::findOrFail($id);
			$employee->status = $status;
            $employee->save();
			
			$statusMsg = ($status=='1') ? 'Activated' : 'Inactivated';
			
            return redirect()->route('admin.receipt.index')->with('flash_success', 'Receipt Status has been '.$statusMsg);
        } 

        catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'Receipt Not Found');
        }
    }
	
	public function printOrder(Request $request,$id)
    {
        try {
			
			if($request->has('page'))
			{
			$receipt = Transaction::where('id', $id)->first();	
			$page = 'transactions';
			
			/*$receipt->receipt_no = $transaction->receipt_no;
			$receipt->donorInfo->first_name = $transaction->cardholder_name;
			$receipt->donorInfo->last_name = '';
			
			$receipt->donorInfo->address = $transaction->address;
			$receipt->donorInfo->postal_code = $transaction->postal_code;
			
			
			$receipt->amount = $transaction->amount;
			$receipt->created_at = $transaction->txt_date;
			$receipt->payment_mode = 'Online';*/
			
			}
			else
			{
			$receipt = Receipt::with('adminInfo','donorInfo')->where('id', $id)->first();
			$page = 'receipts';	
			}
			//dd($receipt);
			return view('admin.receipt.print-order',compact('receipt','page'));
        } 

        catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'Order Not Found');
        }
    }
	
	public function sendEmail(Request $request,$id)
    {
	stream_context_set_default(['ssl' => ['verify_peer' => false, 'verify_peer_name' => false]]);
        try {
		
			if($request->has('page') && $request->get('page')=='transactions')
			{
			$receipt = Transaction::where('id', $id)->first();
			$data["email"] = $receipt->cardholder_email;
			$page = 'transactions';
			}
			else
			{
			$receipt = Receipt::with('adminInfo','donorInfo')->where('id', $id)->first();
			$data["email"] = $receipt->donorInfo->email;
			$page = 'receipts';
			}
			
			//return view('admin.receipt.partials.receipt',compact('receipt','page'));
		
		//dd($data["email"]);
		
			
			//$data["email"] = "tarantechhub@gmail.com";
			
        $data["title"] = "Thanks for Donation at GNFB.com";
  		
		
		PDF::setOptions(['isRemoteEnabled' => TRUE, 'enable_javascript' => TRUE]);	
        $pdf = PDF::loadView('admin.receipt.partials.receipt', compact('receipt','page'));
		//$pdf->setOptions(['enable_javascript', true]);
		//$pdf->setOptions(['javascript-delay', 13500]);
		
		$pdf->setPaper('A4', 'landscape');
  		$pdf->render();
    
	
	/*$output = $pdf->output();	
	dd($output);*/
	
	
	/*Enable this to save pdf on server*/
    //file_put_contents('Brochure.pdf', $output);
	
	/*Enable this to view pdf on browser*/
	//return  $pdf->stream();


//exit(0);
  		
		//dd($pdf->output());
  			
			$name = "GNFB_Donation_Receipt_".$receipt->receipt_no.".pdf";
			
			//dd($data["email"]);
  
  //In try
			
			
  			try{
			$email = Mail::send('admin.receipt.partials.emailreceipt', $data, function($message)use($data, $pdf,$name) {
				$message->to($data["email"], $data["email"])
						->subject($data["title"])
						->attachData($pdf->output(), $name);
			});
			//dd($receipt);
			
			return back()->with('flash_success', 'Email has been sent to Donor');
			
			
			}
			catch(Exception $e){
			return back()->with('flash_error', 'Donor Email address is not valid');
			}
        } 

        catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'Receipt Not Found');
        }
    }
	
	
	
	public function sendSMS(Request $request,$id)
    {
	if($request->has('page') && $request->get('page')=='transactions')
	{
	$transaction = Transaction::where('id', $id)->first();
	$phone = '+'.$transaction->country_code.''.$transaction->contact;
	}
	else
	{
	$receipt = Receipt::with('adminInfo','donorInfo')->where('id', $id)->first();
	$phone = '+'.$receipt->donorInfo->country_code.''.$receipt->donorInfo->contact;
	}
	
	
	
	$message = 'Thank you for your donation. Your generosity means everything to us and to the community we serve.';
	
	$sendsms = sendsms($phone,$message);
	
	if($sendsms['success']=='1')
	{
	return back()->with('flash_success', 'SMS has been sent to Donor');
	}
	else
	{
	return back()->with('flash_error', 'SMS has not been sent to Donor '.$sendsms['message']);
	}
	
	
	}
	
	
	public function sendEmailSMS(Request $request,$id)
	{
	
		try {
		if($request->has('page') && $request->get('page')=='transactions')
		{
		$receipt = Transaction::where('id', $id)->first();
			$data["email"] = $receipt->cardholder_email;
			$page = 'transactions';
			$phone = '+'.$receipt->country_code.''.$receipt->contact;
		}
		else
		{
						
			$receipt = Receipt::with('adminInfo','donorInfo')->where('id', $id)->first();
			$data["email"] = $receipt->donorInfo->email;
			$page = 'receipts';
			$phone = '+'.$receipt->donorInfo->country_code.''.$receipt->donorInfo->contact;
			}
			//$data["email"] = "tarantechhub@gmail.com";
			//$data["email"] = $receipt->donorInfo->email;
        $data["title"] = "Thanks for Donation at GNFB.com";
  		
		
		PDF::setOptions(['isRemoteEnabled' => TRUE, 'enable_javascript' => TRUE]);	
        $pdf = PDF::loadView('admin.receipt.partials.receipt', compact('receipt','page'));
		//$pdf->setOptions(['enable_javascript', true]);
		//$pdf->setOptions(['javascript-delay', 13500]);
		
		$pdf->setPaper('A4', 'landscape');
  		$pdf->render();
    //$output = $pdf->output();
	/*Enable this to save pdf on server*/
    //file_put_contents('Brochure.pdf', $output);
	
	/*Enable this to view pdf on browser*/
	//return  $pdf->stream();


//exit(0);
  		
		//dd($pdf->output());
  			
			$name = "GNFB_Donation_Receipt_".$receipt->receipt_no.".pdf";
  
  
  			try{
			$email = Mail::send('admin.receipt.partials.emailreceipt', $data, function($message)use($data, $pdf,$name) {
				$message->to($data["email"], $data["email"])
						->subject($data["title"])
						->attachData($pdf->output(), $name);
			});
			//dd($receipt);
			
			//return back()->with('flash_success', 'Email has been sent to Donor');
			$emailMessage = 'Email has been sent to Donor';
			$emailCode = '200';
			}
			catch(Exception $e){
			//return back()->with('flash_error', 'Donor Email address is not valid');
			$emailMessage = 'Donor Email address is not valid';
			$emailCode = '201';
			}
			
			
			
			//$phone = '+'.$receipt->donorInfo->country_code.''.$receipt->donorInfo->contact;
	
			$message = 'Thank you for your donation. Your generosity means everything to us and to the community we serve.';
			
			$sendsms = sendsms($phone,$message);
			
			if($sendsms['success']=='1')
			{
			//return back()->with('flash_success', 'SMS has been sent to Donor');
			$smsMessage = 'SMS has been sent to Donor';
			$smsCode = '200';
			}
			else
			{
			//return back()->with('flash_error', 'SMS has not been sent to Donor '.$sendsms['message']);
			$smsMessage = 'SMS has not been sent to Donor '.$sendsms['message'];
			$smsCode = '201';
			}
			
			if($emailCode=='200' && $smsCode=='200')
			{
			return back()->with('flash_success', $emailMessage.'\n'.$smsMessage);
			}
			else
			{
			return back()->with('flash_error', $emailMessage.'\n'.$smsMessage);
			}
			
			
			
        } 

        catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'Receipt Not Found');
        }
	
	
	}
	
	/**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function staffReceipts(Request $request)
    {		
	
	
		if($request->has('donorName'))
		{
		//DB::enableQueryLog();

		$receipts1 = Receipt::with('adminInfo','donorInfo','batchAdminInfo')->where('admin_id',Auth::guard('admin')->user()->id);
		
		
		if($request->has('receiptId') && !empty($request->get('receiptId')))
		{
		$receipts1->where('unique_id',$request->get('receiptId'));
		}
		
		
		if($request->has('donorName') && !empty($request->get('donorName')))
		{
		$donorIds = Donor::where('first_name','LIKE','%'.$request->get('donorName').'%')->orWhere('last_name','LIKE','%'.$request->get('donorName').'%')->pluck('id')->toArray();
		
		$arr = array_unique($donorIds);
		//dd($donorIds);
		
		$receipts1->whereIn('donor_id',$arr);
		}
		
		if($request->has('donorEmailId') && !empty($request->get('donorEmailId')))
		{
		$donorIds = Donor::where('email','LIKE','%'.$request->get('donorEmailId').'%')->pluck('id')->toArray();
		
		$arr = array_unique($donorIds);
		//dd($donorIds);
		
		$receipts1->whereIn('donor_id',$arr);
		}
		
		if($request->has('donorContactNo') && !empty($request->get('donorContactNo')))
		{
		$donorIds = Donor::where('contact','LIKE','%'.$request->get('donorContactNo').'%')->pluck('id')->toArray();
		
		$arr = array_unique($donorIds);
		//dd($donorIds);
		
		$receipts1->whereIn('donor_id',$arr);
		}
		
		$receipts = $receipts1->get();
			//dd(DB::getQueryLog());
		}
		else
		{
		$receipts = '';
		}
		
		//$receipts = Receipt::with('adminInfo','donorInfo')->orderBy('created_at' , 'desc')->get();		
        return view('admin.receipt.staff-receipts', compact('receipts'));
    }
	
	
}
