<?php

namespace App\Http\Controllers\Resource;

use Illuminate\Http\Request;
use App\Helpers\Helper;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use App\Http\Controllers\Controller;
use Exception;
use Storage;

use DB;
use App\Models\Admin;
use App\Models\Customer;
use App\Models\Donor;
use App\Models\Receipt;

class ReportResource extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('demo', ['only' => ['destroy']]);
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
	}

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
	}

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
	}

    /**
     * Display the specified resource.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
	}

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
	}

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
	}

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
	}
	
	/**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function employeeReport(Request $request)
    {
		
		if($request->has('employee') && $request->has('daterange'))
		{
		$daterange = explode(' - ',$request->get('daterange'));
		
		$start = date('Y-m-d',strtotime($daterange[0]));
		$end = date('Y-m-d',strtotime($daterange[1]));
		//dd($start);
		//DB::enableQueryLog();

		$reports = Receipt::with('adminInfo','donorInfo','batchAdminInfo')->where('admin_id',$request->get('employee'))->whereBetween('created_at', [$start." 00:00:00", $end." 23:59:59"])->get();
			//dd(DB::getQueryLog());
		}
		else
		{
		$reports = '';
		}
		$employees = Admin::where('status','1')->orderBy('created_at' , 'desc')->get();
        return view('admin.report.employee-report', compact('employees','reports'));
    }
	
	
	
	
	/**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function donorReport(Request $request)
    {
		
		if($request->has('donor') && $request->has('daterange'))
		{
		$daterange = explode(' - ',$request->get('daterange'));
		
		$start = date('Y-m-d',strtotime($daterange[0]));
		$end = date('Y-m-d',strtotime($daterange[1]));
		//dd($start);
		//DB::enableQueryLog();

		$reports = Receipt::with('adminInfo','donorInfo','batchAdminInfo')->where('donor_id',$request->get('donor'))->whereBetween('created_at', [$start." 00:00:00", $end." 23:59:59"])->get();
			//dd(DB::getQueryLog());
		}
		else
		{
		$reports = '';
		}
		$donors = Donor::where('status','1')->orderBy('created_at' , 'desc')->get();
        return view('admin.report.donor-report', compact('donors','reports'));
    }
	
	public function printOrder($id)
    {
        try {
			$order = WorkOrder::findOrFail($id);
			$customers = Customer::orderBy('created_at' , 'desc')->get();
			//$works = Work::orderBy('id','desc')->get();
			$employees = Employee::where('status','1')->get();
			$works = explode(',',$order->works);
			
			$report = WorkOrderReport::where('workorder_id',$id)->first();
			$work_report = explode(',',$report->works);
			
			return view('admin.workorder.print-order',compact('order','customers','works','employees','report','work_report'));
        } 

        catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'Receipt Not Found');
        }
    }
}
