@extends('admin.includes.base')
@push('styles')
<style>
.table td
{
padding: 15px 10px!important;
}
</style>
@endpush
@section('content')
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Accounting History</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="{{ url('admin/home') }}">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Accounting History</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  @include('common.notify')
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card bg-light">
          <div class="card-body">
            @if(!empty($history))
            <div class="table-responsive">
              <table class="table bg-white table-bordered nowrap display file_export">
                <thead>
                  <tr>
                    <th>Batch Id</th>
                    <th>Closed By</th>
                    <th>Amount</th>
                    <th>Closed On</th>
					<th>Note</th>
					<th>Action</th>
					<th>EDS</th>
                  </tr>
                </thead>
                <tbody>
                
                @foreach($history as $index => $his)
                <tr>
                  <td>#{{ $his->id }}</td>
                  @if(!empty($his->adminInfo))
                  <td>{{ $his->adminInfo->first_name.' '.$his->adminInfo->last_name }}</td>
                  @else
                  <td>-</td>
                  @endif
                  <td>$ {{ $his->total }}</td>
                  <td>{{ date('d/m/Y',strtotime($his->created_at)) }}</td>
				  <td>{{ $his->note ?? '-' }}</td>
				  <td>
				  @if(!empty($his->depositInfo))
				  <a href="{{ route('admin.accounting.deposit.slip.print', $his->depositInfo->id) }}" class="btn btn-success btn-sm">Deposited</a>
				  @else
				  <a href="{{ route('admin.accounting.deposit.slip', $his->id) }}" class="btn btn-warning btn-sm">Deposit Slip</a>
				  @endif
				  </td>
				  <td>
				  @if(!empty($his->depositInfo))
				  {{ $his->depositInfo->serial_no }}
				  @else
				  -
				  @endif
				  </td>
                </tr>
                @endforeach
                </tbody>
                
              </table>
            </div>
            @endif</div>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection
