@extends('admin.includes.base')
@section('content')
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Receipts</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="{{ url('admin/home') }}">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Receipts</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  @include('common.notify')
  <div class="container-fluid">
    <div class="row">
    <div class="col-sm-12 col-md-9">
    <div class="card">
    <div class="card-body padd-10">
      <h4 class="card-title">Update Receipt</h4>
    </div>
    <hr class="m-t-0">
    <form class="form-horizontal r-separator" action="{{route('admin.receipt.update', $receipt->id)}}" method="POST" enctype="multipart/form-data" role="form">
      {{csrf_field()}}
      <input type="hidden" name="_method" value="PATCH">
      <div class="card-body bg-light">
        <h4>Donor Information</h4>
        <div class="row">
          <div class="col-sm-12 col-md-8">
            <div class="row">
              <div class="col-6">
                <div class="form-group">
                  <label for="inputEmail3" class="control-label col-form-label">First Name<span class="asterrisk">*</span></label>
                  <input type="text" class="form-control" id="inputEmail3" name="first_name" value="{{ old('first_name') ?? $donorInfo->first_name }}" autocomplete="off">
                  @if ($errors->has('first_name')) <span class="help-block"> <strong>{{ $errors->first('first_name') }}</strong> </span> @endif </div>
              </div>
              <div class="col-6">
                <div class="form-group">
                  <label for="inputEmail3" class="control-label col-form-label">Last Name<span class="asterrisk">*</span></label>
                  <input type="text" class="form-control" id="inputEmail3" name="last_name" value="{{ old('last_name') ?? $donorInfo->last_name }}" autocomplete="off">
                  @if ($errors->has('last_name')) <span class="help-block"> <strong>{{ $errors->first('last_name') }}</strong> </span> @endif </div>
              </div>
            </div>
          </div>
          <div class="col-sm-12 col-md-4">
            <div class="form-group">
              <label for="inputEmail3" class="control-label col-form-label">Email Address<span class="asterrisk">*</span></label>
              <input type="email" class="form-control" id="inputEmail3" name="email" value="{{ old('email') ?? $donorInfo->email }}" autocomplete="off">
              @if ($errors->has('email')) <span class="help-block"> <strong>{{ $errors->first('email') }}</strong> </span> @endif </div>
          </div>
          <div class="col-sm-12 col-md-6">
            <div class="form-group">
              <label for="inputEmail3" class="control-label col-form-label">Contact Number<span class="asterrisk">*</span></label>
              <div class="row">
                <div class="col-4">
                  <select class="form-control" name="contact_type">
                    <option value="Cell" @if($donorInfo->contact_type=='Cell') selected="selected" @endif>Cell</option>
                    <option value="Home" @if($donorInfo->contact_type=='Home') selected="selected" @endif>Home</option>
                    <option value="Office" @if($donorInfo->contact_type=='Office') selected="selected" @endif>Office</option>
                  </select>
                  @if ($errors->has('contact_type')) <span class="help-block"> <strong>{{ $errors->first('contact_type') }}</strong> </span> @endif </div>
                <div class="phone-div col-8">
                  <input type="hidden" name="country_code" class="country_code" value="{{ old('country_code') ?? $donorInfo->country_code }}"/>
                  <input type="text" class="form-control phone" id="phone" name="contact" value="{{ old('contact')  ?? $donorInfo->contact }}" autocomplete="off">
                  @if ($errors->has('contact')) <span class="help-block"> <strong>{{ $errors->first('contact') }}</strong> </span> @endif </div>
              </div>
            </div>
          </div>
          <div class="col-sm-12 col-md-6">
            <div class="form-group">
              <label for="inputEmail3" class="control-label col-form-label">Alternate Contact Number</label>
              <div class="row">
                <div class="col-4">
                  <select class="form-control" name="alternate_contact_type">
                    <option value="Home" @if($donorInfo->alternate_contact_type=='Home') selected="selected" @endif>Home</option>
                    <option value="Cell" @if($donorInfo->alternate_contact_type=='Cell') selected="selected" @endif>Cell</option>
                    <option value="Office" @if($donorInfo->alternate_contact_type=='Office') selected="selected" @endif>Office</option>
                  </select>
                  @if ($errors->has('alternate_contact_type')) <span class="help-block"> <strong>{{ $errors->first('alternate_contact_type') }}</strong> </span> @endif </div>
                <div class="phone-div col-8">
                  <input type="hidden" name="alternate_country_code" class="country_code" value="{{ old('alternate_country_code') ?? $donorInfo->alternate_country_code }}"/>
                  <input type="text" class="form-control phone" id="phone" name="alternate_contact" value="{{ old('alternate_contact') ?? $donorInfo->alternate_contact }}" autocomplete="off">
                  @if ($errors->has('alternate_contact')) <span class="help-block"> <strong>{{ $errors->first('alternate_contact') }}</strong> </span> @endif </div>
              </div>
            </div>
          </div>
          <div class="col-sm-12 col-md-6">
            <div class="form-group">
              <label for="inputEmail3" class="control-label col-form-label">Address<span class="asterrisk">*</span></label>
              <input id="autocomplete" placeholder="Enter Address" type="text" class="form-control" name="address" value="{{ old('address') ?? $donorInfo->address }}" autocomplete="off">
              <!--<textarea class="form-control" id="inputEmail3" name="address">{{ old('address') }}</textarea>-->
              @if ($errors->has('address')) <span class="help-block"> <strong>{{ $errors->first('address') }}</strong> </span> @endif </div>
          </div>
          <div class="col-sm-12 col-md-6"> </div>
          <div class="row col-12" id="address">
            <div class="col-6">
              <label class="control-label col-form-label">Street address</label>
              <input class="form-control" id="street_number" name="street_number" value="{{ old('street_number') ?? $donorInfo->street_number }}" autocomplete="off">
              @if ($errors->has('street_number')) <span class="help-block"> <strong>{{ $errors->first('street_number') }}</strong> </span> @endif </div>
            <div class="col-6">
              <label class="control-label col-form-label">Route</label>
              <input class="form-control" id="route" name="street_route" value="{{ old('street_route') ?? $donorInfo->street_route }}" autocomplete="off">
              @if ($errors->has('street_route')) <span class="help-block"> <strong>{{ $errors->first('street_route') }}</strong> </span> @endif </div>
            <div class="col-6">
              <label class="control-label col-form-label">City</label>
              <input class="form-control field" id="locality" name="city" value="{{ old('city') ?? $donorInfo->city }}" autocomplete="off">
              @if ($errors->has('city')) <span class="help-block"> <strong>{{ $errors->first('city') }}</strong> </span> @endif </div>
            <div class="col-6">
              <label class="control-label col-form-label">State</label>
              <input class="form-control" id="administrative_area_level_1" name="state" value="{{ old('state') ?? $donorInfo->state }}" autocomplete="off">
              @if ($errors->has('state')) <span class="help-block"> <strong>{{ $errors->first('state') }}</strong> </span> @endif </div>
            <div class="col-6">
              <label class="control-label col-form-label">Postal Code<span class="asterrisk">*</span></label>
              <input class="form-control" id="postal_code" name="postal_code" value="{{ old('postal_code') ?? $donorInfo->postal_code }}" autocomplete="off">
              @if ($errors->has('postal_code')) <span class="help-block"> <strong>{{ $errors->first('postal_code') }}</strong> </span> @endif </div>
            <div class="col-6">
              <label class="control-label col-form-label">Country<span class="asterrisk">*</span></label>
              <input class="form-control" id="country" name="country" value="{{ old('country') ?? $donorInfo->country }}" autocomplete="off">
              @if ($errors->has('country')) <span class="help-block"> <strong>{{ $errors->first('country') }}</strong> </span> @endif </div>
          </div>
        </div>
        <br />
        <br />
        <h4>Payment Information</h4>
        <div class="row">
          <div class="col-sm-12 col-md-6">
            <div class="form-group">
              <label for="inputEmail3" class="control-label col-form-label">Amount(CAD)<span class="asterrisk">*</span></label>
              <input type="text" class="form-control" id="inputEmail3" name="amount" value="{{ old('amount') ?? $receipt->amount }}" autocomplete="off">
              @if ($errors->has('amount')) <span class="help-block"> <strong>{{ $errors->first('amount') }}</strong> </span> @endif </div>
          </div>
          <div class="col-sm-12 col-md-6">
            <div class="form-group">
              <label for="inputEmail3" class="control-label col-form-label">Mode of Payment<span class="asterrisk">*</span></label>
              <select name="payment_mode" id="mode_of_payment" class="form-control">
                <option value="">Mode of Payment</option>
                <option value="Cash" @if($receipt->payment_mode=='Cash') selected="selected" @endif>Cash</option>
                <option value="Cheque" @if($receipt->payment_mode=='Cheque') selected="selected" @endif>Cheque</option>
                <!--<option value="Pledge" @if(old('payment_mode')=='Pledge') selected="selected" @endif>Pledge</option>
                    <option value="Card" @if(old('payment_mode')=='Card') selected="selected" @endif>Card</option>-->
                <option value="Online" @if($receipt->payment_mode=='Online') selected="selected" @endif>Online/Website</option>
                <option value="E-Transfer" @if($receipt->payment_mode=='E-Transfer') selected="selected" @endif>E-Transfer</option>
                <option value="Pledge" @if($receipt->payment_mode=='Pledge') selected="selected" @endif>Pledge</option>
				<option value="Credit Card" @if($receipt->payment_mode=='Credit Card') selected="selected" @endif>Credit Card</option>
              </select>
              @if ($errors->has('payment_mode')) <span class="help-block"> <strong>{{ $errors->first('payment_mode') }}</strong> </span> @endif </div>
          </div>
        </div>
        <div class="divPaymentOptions divCard mt-1" @if($receipt->payment_mode=='Card') style="display: block;" @else style="display: none;" @endif>
        <div class="row">
          <div class="col-sm-12 col-md-6">
            <div class="form-group">
              <label for="card_number">Card Number</label>
              <input type="number" name="card_number" id="card_number" class="form-control" placeholder="16 digit card number" autocomplete="off">
              @if ($errors->has('card_number')) <span class="help-block"> <strong>{{ $errors->first('card_number') }}</strong> </span> @endif </div>
          </div>
          <div class="col-sm-12 col-md-6">
            <div class="row">
              <div class="col-4">
                <div class="form-group">
                  <label for="expiry_month">Expiry Month</label>
                  <select name="expiry_month" id="expiry_month" class="form-control">
                    <option value="01">Jan</option>
                    <option value="02">Feb</option>
                    <option value="03">Mar</option>
                    <option value="04">Apr</option>
                    <option value="05">May</option>
                    <option value="06">Jun</option>
                    <option value="07">Jul</option>
                    <option value="08">Aug</option>
                    <option value="09">Sep</option>
                    <option value="10">Oct</option>
                    <option value="11">Nov</option>
                    <option value="12">Dec</option>
                  </select>
                  @if ($errors->has('expiry_month')) <span class="help-block"> <strong>{{ $errors->first('expiry_month') }}</strong> </span> @endif </div>
              </div>
              <div class="col-4">
                <div class="form-group">
                  <label for="expiry_year">Expiry Year</label>
                  <select name="expiry_year" id="expiry_year" class="form-control">
                    
                    
                    
                            
					  	@php
					  	$firstYear = (int)date('Y');
						$lastYear = $firstYear + 10;
						@endphp
						
						@for($i=$firstYear;$i<=$lastYear;$i++)
						{
							
                            
                    
                    
                    <option value="{{ $i }}">{{ $i }}</option>
                    
                    
                    
                            
						}
						@endfor
                      
                          
                  
                  
                  </select>
                  @if ($errors->has('expiry_year')) <span class="help-block"> <strong>{{ $errors->first('expiry_year') }}</strong> </span> @endif </div>
              </div>
              <div class="col-4">
                <div class="form-group">
                  <label for="expiry_year">CVV</label>
                  <input type="number" name="cvv" id="cvv" class="form-control" placeholder="CVV" autocomplete="off">
                  @if ($errors->has('cvv')) <span class="help-block"> <strong>{{ $errors->first('cvv') }}</strong> </span> @endif </div>
              </div>
            </div>
          </div>
          <hr>
        </div>
      </div>
      <div class="divPaymentOptions divCheque mt-1"  @if($receipt->payment_mode=='Cheque') style="display: block;" @else style="display: none;" @endif>
      <div class="row">
        <div class="col-sm-12 col-md-6">
          <div>
            <label for="cheque_no">Cheque No.</label>
            <input class="form-control" type="text" name="cheque_no" id="cheque_no" placeholder="Cheque number" autocomplete="off">
            @if ($errors->has('cheque_no')) <span class="help-block"> <strong>{{ $errors->first('cheque_no') }}</strong> </span> @endif </div>
        </div>
        <div class="col-sm-12 col-md-6">
          <div class="mt-1">
            <label for="cheque_date">Cheque Date</label>
            <input class="form-control" type="date" name="cheque_date" id="cheque_date" placeholder="Cheque date" autocomplete="off">
            @if ($errors->has('cheque_date')) <span class="help-block"> <strong>{{ $errors->first('cheque_date') }}</strong> </span> @endif </div>
        </div>
        <hr>
      </div>
      </div>
      <div class="divPaymentOptions divPledge mt-1"  @if($receipt->payment_mode=='Pledge') style="display: block;" @else style="display: none;" @endif>
      <div class="row">
        <div class="col-sm-12 col-md-6">
          <div>
            <label for="pledge_date">Pledge Date</label>
            <input class="form-control" type="date" name="pledge_date" id="pledge_date" placeholder="Approx date to donate" autocomplete="off">
            @if ($errors->has('pledge_date')) <span class="help-block"> <strong>{{ $errors->first('pledge_date') }}</strong> </span> @endif </div>
        </div>
        <hr>
      </div>
      </div>
      <div class="row">
        <div class="col-sm-12 col-md-6" style="display:none;">
          <div class="form-group">
            <label for="inputEmail3" class="control-label col-form-label">Mode of Payment<span class="asterrisk">*</span></label>
            <select name="payment_frequency" id="payment_frequency" class="form-control">
              <option value="One Time" selected="selected"> One Time Payment </option>
              <option value="Recurring"> Recurring Payment </option>
            </select>
            @if ($errors->has('payment_frequency')) <span class="help-block"> <strong>{{ $errors->first('payment_frequency') }}</strong> </span> @endif </div>
        </div>
        <div class="col-sm-12 col-md-6">
          <div class="form-group">
            <label for="inputEmail3" class="control-label col-form-label">Payment Status<span class="asterrisk">*</span></label>
            <select name="payment_status" id="payment_status" class="form-control">
              <option value="Not Paid" @if($receipt->payment_status=="Not Paid") selected="selected" @endif>Not Paid</option>
              <option value="Paid" @if($receipt->payment_status=="Paid") selected="selected" @endif>Paid</option>
              <!--<option value="Cancelled">Cancelled</option>-->
            </select>
            @if ($errors->has('payment_status')) <span class="help-block"> <strong>{{ $errors->first('payment_status') }}</strong> </span> @endif </div>
        </div>
      </div>
      <div class="row">
        <div class="col-sm-12 col-md-12">
          <div class="form-group">
            <label for="inputEmail3" class="control-label col-form-label">Remarks</label>
            <textarea type="text" class="form-control" id="inputEmail3" name="remarks" autocomplete="off">{{ old('remarks') ?? $receipt->remarks }}</textarea>
            @if ($errors->has('remarks')) <span class="help-block"> <strong>{{ $errors->first('remarks') }}</strong> </span> @endif </div>
        </div>
      </div>
      </div>
      <div class="card-body">
        <div class="form-group m-b-0 text-right">
          <button type="submit" class="btn btn-info waves-effect waves-light">Save Donation</button>
          <!--<a href="{{route('admin.receipt.index')}}" class="btn btn-dark waves-effect waves-light deactive_button">Cancel</a>-->
        </div>
      </div>
    </form>
  </div>
  @push('scripts')
  <script>
$(document).on('change', '#mode_of_payment', function() {
                $('.divPaymentOptions').hide();
                if($(this).val().toLowerCase() == 'cheque') {
                    $('.divCheque').show();
					$('#payment_status').val('Not Paid');
                } else if($(this).val().toLowerCase() == 'pledge') {
                    $('.divPledge').show();
					$('#payment_status').val('Not Paid');
                } else if($(this).val().toLowerCase() == 'card') {
                    $('.divCard').show();
					$('#payment_status').val('Paid');
                }
				else
				{
				$('#payment_status').val('Paid');
				}
            });
</script>
  @endpush </div>
</div>
</div>
</div>
@endsection 