@extends('admin.includes.base')
@section('content')
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Transactions</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="{{ url('admin/home') }}">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Transactions</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  @include('common.notify')
  <div class="container-fluid">
    <div class="row">
      <div class="col-sm-12 col-md-9">
        <div class="card">
          <div class="card-body padd-10">
            <h4 class="card-title">Update Transaction</h4>
          </div>
          <hr class="m-t-0">
          <form class="form-horizontal r-separator" action="{{route('admin.transaction.update', $transaction->id)}}" method="POST" enctype="multipart/form-data" role="form">
            {{csrf_field()}}
            <input type="hidden" name="_method" value="PATCH">
            <div class="card-body bg-light">
              <div class="row">
                <div class="col-sm-12 col-md-4">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Email Address<span class="asterrisk">*</span></label>
                    <input type="email" class="form-control" id="inputEmail3" name="email" value="{{ old('email') ?? $transaction->cardholder_email }}" autocomplete="off">
                    @if ($errors->has('email')) <span class="help-block"> <strong>{{ $errors->first('email') }}</strong> </span> @endif </div>
                </div>
                <div class="col-sm-12 col-md-6">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Contact Number<span class="asterrisk">*</span></label>
                    <div class="row">
                      <div class="col-4">
                        <select class="form-control" name="contact_type">
                          <option value="Cell" @if($transaction->contact_type=='Cell') selected="selected" @endif>Cell</option>
                          <option value="Home" @if($transaction->contact_type=='Home') selected="selected" @endif>Home</option>
                          <option value="Office" @if($transaction->contact_type=='Office') selected="selected" @endif>Office</option>
                        </select>
                        @if ($errors->has('contact_type')) <span class="help-block"> <strong>{{ $errors->first('contact_type') }}</strong> </span> @endif </div>
                      <div class="phone-div col-8">
                        <input type="hidden" name="country_code" class="country_code" value="{{ old('country_code') ?? $transaction->country_code }}"/>
                        <input type="text" class="form-control phone" id="phone" name="contact" value="{{ old('contact')  ?? $transaction->contact }}" autocomplete="off">
                        @if ($errors->has('contact')) <span class="help-block"> <strong>{{ $errors->first('contact') }}</strong> </span> @endif </div>
                    </div>
                  </div>
                </div>
                <div class="col-sm-12 col-md-6">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Address<span class="asterrisk">*</span></label>
                    <input id="autocomplete" placeholder="Enter Address" type="text" class="form-control" name="address" value="{{ old('address') ?? $transaction->address }}" autocomplete="off">
                    <!--<textarea class="form-control" id="inputEmail3" name="address">{{ old('address') }}</textarea>-->
                    @if ($errors->has('address')) <span class="help-block"> <strong>{{ $errors->first('address') }}</strong> </span> @endif </div>
                </div>
                <div class="col-sm-12 col-md-6"> </div>
                <div class="row col-12" id="address">
                  <div class="col-6">
                    <label class="control-label col-form-label">Street address</label>
                    <input class="form-control" id="street_number" name="street_number" value="{{ old('street_number') ?? $transaction->street_number }}" autocomplete="off">
                    @if ($errors->has('street_number')) <span class="help-block"> <strong>{{ $errors->first('street_number') }}</strong> </span> @endif </div>
                  <div class="col-6">
                    <label class="control-label col-form-label">Route</label>
                    <input class="form-control" id="route" name="street_route" value="{{ old('street_route') ?? $transaction->street_route }}" autocomplete="off">
                    @if ($errors->has('street_route')) <span class="help-block"> <strong>{{ $errors->first('street_route') }}</strong> </span> @endif </div>
                  <div class="col-6">
                    <label class="control-label col-form-label">City</label>
                    <input class="form-control field" id="locality" name="city" value="{{ old('city') ?? $transaction->city }}" autocomplete="off">
                    @if ($errors->has('city')) <span class="help-block"> <strong>{{ $errors->first('city') }}</strong> </span> @endif </div>
                  <div class="col-6">
                    <label class="control-label col-form-label">State</label>
                    <input class="form-control" id="administrative_area_level_1" name="state" value="{{ old('state') ?? $transaction->state }}" autocomplete="off">
                    @if ($errors->has('state')) <span class="help-block"> <strong>{{ $errors->first('state') }}</strong> </span> @endif </div>
                  <div class="col-6">
                    <label class="control-label col-form-label">Postal Code<span class="asterrisk">*</span></label>
                    <input class="form-control" id="postal_code" name="postal_code" value="{{ old('postal_code') ?? $transaction->postal_code }}" autocomplete="off">
                    @if ($errors->has('postal_code')) <span class="help-block"> <strong>{{ $errors->first('postal_code') }}</strong> </span> @endif </div>
                  <div class="col-6">
                    <label class="control-label col-form-label">Country<span class="asterrisk">*</span></label>
                    <input class="form-control" id="country" name="country" value="{{ old('country') ?? $transaction->country }}" autocomplete="off">
                    @if ($errors->has('country')) <span class="help-block"> <strong>{{ $errors->first('country') }}</strong> </span> @endif </div>
                </div>
                <div class="row col-12">
                  <div class="col-6">
                    <label class="control-label col-form-label">Date<span class="asterrisk">*</span></label>
                    <input class="form-control mydatepicker" id="created_at" name="created_at" value="{{ old('created_at') ?? date('Y-m-d',strtotime($transaction->created_at)) }}" autocomplete="off">
                    @if ($errors->has('created_at')) <span class="help-block"> <strong>{{ $errors->first('created_at') }}</strong> </span> @endif </div>
                  <div class="col-6">
                    <label class="control-label col-form-label">Sent Status<span class="asterrisk">*</span></label>
                    <select class="form-control" name="is_sent">
                      <option value="0" @if($transaction->is_sent=='0') selected="selected" @endif>Not Sent</option>
                      <option value="1" @if($transaction->is_sent=='1') selected="selected" @endif>Sent</option>
                    </select>
                    @if ($errors->has('is_sent')) <span class="help-block"> <strong>{{ $errors->first('is_sent') }}</strong> </span> @endif </div>
					<div class="col-12">
					<label class="control-label col-form-label">Sent Remarks<span class="asterrisk">*</span></label>
                    <textarea class="form-control" id="sent_remarks" name="sent_remarks">{{ old('sent_remarks') ?? $transaction->sent_remarks }}</textarea>
                    @if ($errors->has('sent_remarks')) <span class="help-block"> <strong>{{ $errors->first('sent_remarks') }}</strong> </span> @endif
					</div>
                </div>
              </div>
            </div>
            <div class="card-body">
              <div class="form-group m-b-0 text-right">
                <button type="submit" class="btn btn-info waves-effect waves-light">Save</button>
              </div>
            </div>
          </form>
        </div>
        @push('scripts')
        
        @endpush </div>
    </div>
  </div>
</div>
@endsection 