<!-- Card -->

<div class="card">
  <div class="card-header"> Donor Details </div>
  <div class="card-body"> @if(!empty($receipt->donorInfo))
    <div class="row">
      <div class="col-md-6">
        <div class="form-group">
          <label class="control-label col-md-12"><strong>Full Name</strong></label>
          <div class="col-md-12">
            <p class="form-control-static">{{ $receipt->donorInfo->first_name.' '.$receipt->donorInfo->last_name }}</p>
          </div>
        </div>
      </div>
      <!--/span-->
      <div class="col-md-6">
        <div class="form-group">
          <label class="control-label col-md-12"><strong>Contact Number</strong></label>
          <div class="col-md-12">
            <p class="form-control-static"> {{ $receipt->donorInfo->contact }} </p>
          </div>
        </div>
      </div>
      <!--/span-->
    </div>
    <div class="row">
      <div class="col-md-6">
        <div class="form-group">
          <label class="control-label col-md-12"><strong>Address</strong></label>
          <div class="col-md-9">
            <p class="form-control-static">{{ $receipt->donorInfo->address }}</p>
          </div>
        </div>
      </div>
      <!--/span-->
      <div class="col-md-6">
        <div class="form-group">
          <label class="control-label col-md-12"><strong>Zipcode</strong></label>
          <div class="col-md-9">
            <p class="form-control-static"> {{ $receipt->donorInfo->zipcode }} </p>
          </div>
        </div>
      </div>
      <!--/span-->
    </div>
    @else
    <p>Donor does not exists!</p>
    @endif
    <!--/row-->
  </div>
</div>
<!-- Card -->
<div class="card">
  <div class="card-header"> Admin Details </div>
  <div class="card-body"> @if(!empty($receipt->adminInfo))
    <div class="row">
      <div class="col-md-6">
        <div class="form-group">
          <label class="control-label col-md-12"><strong>Full Name</strong></label>
          <div class="col-md-12">
            <p class="form-control-static">{{ $receipt->adminInfo->first_name.' '.$receipt->adminInfo->last_name }}</p>
          </div>
        </div>
      </div>
      <!--/span-->
      <div class="col-md-6">
        <div class="form-group">
          <label class="control-label col-md-12"><strong>Contact Number</strong></label>
          <div class="col-md-12">
            <p class="form-control-static"> {{ $receipt->adminInfo->contact }} </p>
          </div>
        </div>
      </div>
      <!--/span-->
    </div>
    <div class="row">
      <div class="col-md-6">
        <div class="form-group">
          <label class="control-label col-md-12"><strong>Email</strong></label>
          <div class="col-md-12">
            <p class="form-control-static"><a href="mailto:{{ $receipt->adminInfo->email }}">{{ $receipt->adminInfo->email }}</a></p>
          </div>
        </div>
      </div>
      <!--/span-->
      <div class="col-md-6"> </div>
      <!--/span-->
    </div>
    @else
    <p>Admin does not exists!</p>
    @endif
    <!--/row-->
  </div>
</div>
<div class="card">
  <div class="card-header"> Receipt Details </div>
  <div class="card-body">
    <div class="row">
      <div class="col-md-6">
        <div class="form-group">
          <label class="control-label col-md-12"><strong>Receipt No</strong></label>
          <div class="col-md-12">
            <p class="form-control-static">{{ $receipt->receipt_no }}</p>
          </div>
        </div>
      </div>
      <!--/span-->
      <div class="col-md-6">
        <div class="form-group">
          <label class="control-label col-md-12"><strong>Amount</strong></label>
          <div class="col-md-12">
            <p class="form-control-static">$ {{ $receipt->amount }} </p>
          </div>
        </div>
      </div>
      <!--/span-->
    </div>
    <div class="row">
      <div class="col-md-6">
        <div class="form-group">
          <label class="control-label col-md-12"><strong>Payment Mode</strong></label>
          <div class="col-md-12">
            <p class="form-control-static">{{ $receipt->payment_mode }}</p>
          </div>
        </div>
      </div>
      <!--/span-->
      <div class="col-md-6">
        <div class="form-group">
          <label class="control-label col-md-12"><strong>Payment Status</strong></label>
          <div class="col-md-12">
            <p class="form-control-static"> @if($receipt->payment_status=='Paid') <span class="label label-success">Paid
              </label>
              @else <span class="label label-danger">Not Paid
              </label>
              @endif </p>
          </div>
        </div>
      </div>
      <!--/span-->
    </div>
    <!--/row-->
  </div>
</div>
<div class="modal-footer">
@if($receipt->payment_status=='Paid')
@else
  <button type="button" class="btn btn-primary mark-paid" data-id="{{ $receipt->id }}">Mark as Paid</button>
  @endif
</div>
