<?php $__env->startPush('styles'); ?>
<style>
.table td
{
padding: 15px 10px!important;
}
</style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Accounting History</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="<?php echo e(url('admin/home')); ?>">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Accounting History</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php echo $__env->make('common.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card bg-light">
          <div class="card-body">
            <?php if(!empty($history)): ?>
            <div class="table-responsive">
              <table class="table bg-white table-bordered nowrap display file_export">
                <thead>
                  <tr>
                    <th>Batch Id</th>
                    <th>Closed By</th>
                    <th>Amount</th>
                    <th>Closed On</th>
					<th>Note</th>
					<th>Action</th>
					<th>EDS</th>
                  </tr>
                </thead>
                <tbody>
                
                <?php $__currentLoopData = $history; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $his): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td>#<?php echo e($his->id); ?></td>
                  <?php if(!empty($his->adminInfo)): ?>
                  <td><?php echo e($his->adminInfo->first_name.' '.$his->adminInfo->last_name); ?></td>
                  <?php else: ?>
                  <td>-</td>
                  <?php endif; ?>
                  <td>$ <?php echo e($his->total); ?></td>
                  <td><?php echo e(date('d/m/Y',strtotime($his->created_at))); ?></td>
				  <td><?php echo e($his->note ?? '-'); ?></td>
				  <td>
				  <?php if(!empty($his->depositInfo)): ?>
				  <a href="<?php echo e(route('admin.accounting.deposit.slip.print', $his->depositInfo->id)); ?>" class="btn btn-success btn-sm">Deposited</a>
				  <?php else: ?>
				  <a href="<?php echo e(route('admin.accounting.deposit.slip', $his->id)); ?>" class="btn btn-warning btn-sm">Deposit Slip</a>
				  <?php endif; ?>
				  </td>
				  <td>
				  <?php if(!empty($his->depositInfo)): ?>
				  <?php echo e($his->depositInfo->serial_no); ?>

				  <?php else: ?>
				  -
				  <?php endif; ?>
				  </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                
              </table>
            </div>
            <?php endif; ?></div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.includes.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/donationgnfb/public_html/resources/views/admin/accounting/history.blade.php ENDPATH**/ ?>