<!-- Card -->

<div class="card">
  <div class="card-header"> Donor Details </div>
  <div class="card-body"> <?php if(!empty($receipt->donorInfo)): ?>
    <div class="row">
      <div class="col-md-6">
        <div class="form-group">
          <label class="control-label col-md-12"><strong>Full Name</strong></label>
          <div class="col-md-12">
            <p class="form-control-static"><?php echo e($receipt->donorInfo->first_name.' '.$receipt->donorInfo->last_name); ?></p>
          </div>
        </div>
      </div>
      <!--/span-->
      <div class="col-md-6">
        <div class="form-group">
          <label class="control-label col-md-12"><strong>Contact Number</strong></label>
          <div class="col-md-12">
            <p class="form-control-static"> <?php echo e($receipt->donorInfo->contact); ?> </p>
          </div>
        </div>
      </div>
      <!--/span-->
    </div>
    <div class="row">
      <div class="col-md-6">
        <div class="form-group">
          <label class="control-label col-md-12"><strong>Address</strong></label>
          <div class="col-md-9">
            <p class="form-control-static"><?php echo e($receipt->donorInfo->address); ?></p>
          </div>
        </div>
      </div>
      <!--/span-->
      <div class="col-md-6">
        <div class="form-group">
          <label class="control-label col-md-12"><strong>Zipcode</strong></label>
          <div class="col-md-9">
            <p class="form-control-static"> <?php echo e($receipt->donorInfo->zipcode); ?> </p>
          </div>
        </div>
      </div>
      <!--/span-->
    </div>
    <?php else: ?>
    <p>Donor does not exists!</p>
    <?php endif; ?>
    <!--/row-->
  </div>
</div>
<!-- Card -->
<div class="card">
  <div class="card-header"> Admin Details </div>
  <div class="card-body"> <?php if(!empty($receipt->adminInfo)): ?>
    <div class="row">
      <div class="col-md-6">
        <div class="form-group">
          <label class="control-label col-md-12"><strong>Full Name</strong></label>
          <div class="col-md-12">
            <p class="form-control-static"><?php echo e($receipt->adminInfo->first_name.' '.$receipt->adminInfo->last_name); ?></p>
          </div>
        </div>
      </div>
      <!--/span-->
      <div class="col-md-6">
        <div class="form-group">
          <label class="control-label col-md-12"><strong>Contact Number</strong></label>
          <div class="col-md-12">
            <p class="form-control-static"> <?php echo e($receipt->adminInfo->contact); ?> </p>
          </div>
        </div>
      </div>
      <!--/span-->
    </div>
    <div class="row">
      <div class="col-md-6">
        <div class="form-group">
          <label class="control-label col-md-12"><strong>Email</strong></label>
          <div class="col-md-12">
            <p class="form-control-static"><a href="mailto:<?php echo e($receipt->adminInfo->email); ?>"><?php echo e($receipt->adminInfo->email); ?></a></p>
          </div>
        </div>
      </div>
      <!--/span-->
      <div class="col-md-6"> </div>
      <!--/span-->
    </div>
    <?php else: ?>
    <p>Admin does not exists!</p>
    <?php endif; ?>
    <!--/row-->
  </div>
</div>
<div class="card">
  <div class="card-header"> Receipt Details </div>
  <div class="card-body">
    <div class="row">
      <div class="col-md-6">
        <div class="form-group">
          <label class="control-label col-md-12"><strong>Receipt No</strong></label>
          <div class="col-md-12">
            <p class="form-control-static"><?php echo e($receipt->receipt_no); ?></p>
          </div>
        </div>
      </div>
      <!--/span-->
      <div class="col-md-6">
        <div class="form-group">
          <label class="control-label col-md-12"><strong>Amount</strong></label>
          <div class="col-md-12">
            <p class="form-control-static">$ <?php echo e($receipt->amount); ?> </p>
          </div>
        </div>
      </div>
      <!--/span-->
    </div>
    <div class="row">
      <div class="col-md-6">
        <div class="form-group">
          <label class="control-label col-md-12"><strong>Payment Mode</strong></label>
          <div class="col-md-12">
            <p class="form-control-static"><?php echo e($receipt->payment_mode); ?></p>
          </div>
        </div>
      </div>
      <!--/span-->
      <div class="col-md-6">
        <div class="form-group">
          <label class="control-label col-md-12"><strong>Payment Status</strong></label>
          <div class="col-md-12">
            <p class="form-control-static"> <?php if($receipt->payment_status=='Paid'): ?> <span class="label label-success">Paid
              </label>
              <?php else: ?> <span class="label label-danger">Not Paid
              </label>
              <?php endif; ?> </p>
          </div>
        </div>
      </div>
      <!--/span-->
    </div>
    <!--/row-->
  </div>
</div>
<div class="modal-footer">
<?php if($receipt->payment_status=='Paid'): ?>
<?php else: ?>
  <button type="button" class="btn btn-primary mark-paid" data-id="<?php echo e($receipt->id); ?>">Mark as Paid</button>
  <?php endif; ?>
</div>
<?php /**PATH /home/donation/public_html/resources/views/ajax/receipt-info.blade.php ENDPATH**/ ?>