<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Users</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="<?php echo e(url('admin/home')); ?>">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Users</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php echo $__env->make('common.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card bg-light">
          <div class="card-body">
            <div class="d-flex m-b-30 no-block">
              <h5 class="card-title m-b-0 align-self-center">View Users</h5>
              <div class="ml-auto">
                <div class="dl">
                  <div class="col-3 align-self-center"> <a class="btn btn-primary" href="<?php echo e(route('admin.admin.create')); ?>"><i class="icon-Add"></i> Add User</a> </div>
                </div>
              </div>
            </div>
            <div class="table-responsive">
              <table class="table bg-white table-bordered nowrap display file_export">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Full Name</th>
					<th>Email Id</th>
					<th>Contact Number</th>
					<th>Role</th>
					<th>Joined On</th>
                    <th class="noExport">Actions</th>
                  </tr>
                </thead>
                <tbody>
                
                <?php $__currentLoopData = $admins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td><?php echo e($index + 1); ?></td>
                  <td><?php echo e($cat->name); ?></td>
				  <td><a href="mailto:<?php echo e($cat->email); ?>"><?php echo e($cat->email); ?></a></td>
				  <th><?php echo e($cat->contact); ?></th>
				  <th>
				  <?php if($cat->utype=='Admin'): ?>
				  <label class="label label-info">Admin</label>
				  <?php elseif($cat->utype=='Treasury'): ?>
				  <label class="label label-primary">Treasury</label>
				  <?php else: ?>
				  <label class="label label-success">Staff Member</label>
				  <?php endif; ?>
				  </th>
				  <th><?php echo e(date('d/m/Y',strtotime($cat->created_at))); ?></th>
                  <td><form action="<?php echo e(route('admin.admin.destroy', $cat->id)); ?>" method="POST">
                      <?php echo e(csrf_field()); ?>

                      <input type="hidden" name="_method" value="DELETE">
                      <a href="<?php echo e(route('admin.admin.edit', $cat->id)); ?>" class="btn btn-info btn-sm"><i class="fa fa-edit"></i> Edit</a>
                      <button onclick="return confirm('Are you sure?')" class="btn btn-danger btn-sm"><i class="fa fa-trash-alt"></i> Delete</button>
                    </form></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.includes.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/donation/public_html/resources/views/admin/admin/index.blade.php ENDPATH**/ ?>