<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Helpers\Helper;

use Auth;
use Exception;
use \Carbon\Carbon;

use App\Models\Donor;
use App\Models\Receipt;
use DB;

class AjaxController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('admin');
    } 

	public function loadReceiptData(Request $request)
    {
        $receipt_id = $request->receipt_id;
		
		$receipt = Receipt::with('adminInfo','donorInfo')->where('id',$receipt_id)->first();
		
		return view('ajax.receipt-info', compact('receipt'));
		
    }
	
	
	public function markPaidReceipt(Request $request)
    {
        $receipt_id = $request->receipt_id;
		
		$receipt = Receipt::where('id',$receipt_id)->first();
		$receipt->payment_status = 'Paid';
		$receipt->save();
		
		$receipt = Receipt::with('adminInfo','donorInfo')->where('id',$receipt_id)->first();
		
		return view('ajax.receipt-info', compact('receipt'));
		
    }
	
	
	public function fetchDonor(Request $request)
    {
	//echo 'taran';
		 	$query = $request->get('query');
			//$query = '9876';
			/*$donors = Donor::where('contact','LIKE','%'.$query.'%')->orWhere('first_name',$query)->orWhere('last_name',$query)->orWhere('email',$query)->get();*/
			/*$donors = Donor::where('contact', 'LIKE', '%'.$query.'%')
						->orWhere('first_name', 'LIKE', '%'.$query.'%')
						->orWhere('last_name', 'LIKE', '%'.$query.'%')
						->orWhere('email', 'LIKE', '%'.$query.'%')
						->get();*/
						
			$donors = Donor::select(
							DB::raw('ANY_VALUE(id) as id'),
							DB::raw('ANY_VALUE(contact) as contact'),
							DB::raw('ANY_VALUE(first_name) as first_name'),
							DB::raw('ANY_VALUE(last_name) as last_name'),
							'email',
							'contact'
						)
						->where('contact', 'LIKE', '%'.$query.'%')
						->orWhere('first_name', 'LIKE', '%'.$query.'%')
						->orWhere('last_name', 'LIKE', '%'.$query.'%')
						->orWhere('email', 'LIKE', '%'.$query.'%')
						->groupBy('email', 'contact')
						->get();
			
			
			return view('ajax.donors-info', compact('donors'));
		
    }

    
	
	

}
