<?php

namespace App\Http\Controllers\Resource;

use Illuminate\Http\Request;
use App\Helpers\Helper;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use App\Http\Controllers\Controller;
use Exception;
use Storage;

use DB;
use App\Models\Admin;
use App\Models\Donor;
use App\Models\Receipt;
use App\Models\Accounting;
use Illuminate\Http\Response;
use Validator;
use Auth;
use App\Models\Deposit;


class AccountingResource extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('demo', ['only' => ['destroy']]);
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
		if($request->has('employee') && $request->has('daterange'))
		{
		if($request->get('employee')=='All')
		{
		$reports = Receipt::with('adminInfo','donorInfo')->where('batch_status','Open')->get();
		}
		else
		{
		$daterange = explode(' - ',$request->get('daterange'));
		
		$start = date('Y-m-d',strtotime($daterange[0]));
		$end = date('Y-m-d',strtotime($daterange[1]));
		//dd($start);
		//DB::enableQueryLog();

		//$reports = Receipt::with('adminInfo','donorInfo')->where('admin_id',$request->get('employee'))->whereBetween('created_at', [$start." 00:00:00", $end." 23:59:59"])->where('payment_status','Paid')->where('batch_status','Open')->get();
		
		$reports = Receipt::with('adminInfo','donorInfo')->where('admin_id',$request->get('employee'))->whereBetween('created_at', [$start." 00:00:00", $end." 23:59:59"])->where('batch_status','Open')->get();
		
			//dd(DB::getQueryLog());
		}
		}
		else
		{
		$reports = '';
		}
		$employees = Admin::where('status','1')->orderBy('created_at' , 'desc')->get();
        return view('admin.accounting.index', compact('employees','reports'));
	}

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
	}

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
		$validator = Validator::make($request->all(),[
			'total' => 'required|max:255',
			'updated_by' => 'required|max:255'
        ]		
		);
		
		if ($validator->fails())
        {
            //return response()->json(['errors'=>$validator->errors()->all()]);
			
			return response()->json(['errors'=>$validator->getMessageBag()->toArray()]);
        }
		          
        try{
			$check_list = explode(',',$request->check_list); 
			$total = $request->total;
			$updated_by = $request->updated_by;
			
			if(!empty($check_list))
			{
			foreach($check_list as $check)
			{
			$receipt = Receipt::where('id',$check)->first();
			$receipt->batch_status = 'Closed';
			$receipt->batch_updated_by = Auth::guard('admin')->user()->id;
			$receipt->batch_updated_on = date('Y-m-d H:i:s');
			$receipt->save();			
			}
			}
			
			
		
            $accounting = $request->all();
			$accounting['admin_id'] = Auth::guard('admin')->user()->id;
			$accounting['receipt_ids'] = $request->check_list;
			$accounting['total'] = $total;
			$accounting['note'] = $request->note;
			
			$accounting = Accounting::create($accounting);

            //return back()->with('flash_success',translate('Donor Details Saved Successfully'));
			return response()->json(['message'=>'Batch Closed Successfully']);

        } 

        catch (Exception $e) {
            //return back()->with('flash_error', translate('Something went wrong. Please try again later'));
			return response()->json(['message'=>translate('Something went wrong. Please try again later')]);
        }
	
	
	
		
		
		
		
		
		
		
	}

    /**
     * Display the specified resource.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
	}

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
	}

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
	}

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
	}
	
	/**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function history(Request $request)
    {
		$history = Accounting::with('adminInfo','depositInfo')->orderBy('created_at' , 'desc')->get();
		
		//dd($history);
        return view('admin.accounting.history', compact('history'));
    }
	
	
	
	
	
	
	/**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function donorReport(Request $request)
    {
		
		if($request->has('donor') && $request->has('daterange'))
		{
		$daterange = explode(' - ',$request->get('daterange'));
		
		$start = date('Y-m-d',strtotime($daterange[0]));
		$end = date('Y-m-d',strtotime($daterange[1]));
		//dd($start);
		//DB::enableQueryLog();

		$reports = Receipt::with('adminInfo','donorInfo')->where('donor_id',$request->get('donor'))->whereBetween('created_at', [$start." 00:00:00", $end." 23:59:59"])->get();
			//dd(DB::getQueryLog());
		}
		else
		{
		$reports = '';
		}
		$donors = Donor::where('status','1')->orderBy('created_at' , 'desc')->get();
        return view('admin.report.donor-report', compact('donors','reports'));
    }
	
	public function printOrder($id)
    {
        try {
			$order = WorkOrder::findOrFail($id);
			$customers = Customer::orderBy('created_at' , 'desc')->get();
			//$works = Work::orderBy('id','desc')->get();
			$employees = Employee::where('status','1')->get();
			$works = explode(',',$order->works);
			
			$report = WorkOrderReport::where('workorder_id',$id)->first();
			$work_report = explode(',',$report->works);
			
			return view('admin.workorder.print-order',compact('order','customers','works','employees','report','work_report'));
        } 

        catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'Receipt Not Found');
        }
    }
	
	/**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function filter(Request $request)
    {
		if($request->has('daterange'))
		{
		$daterange = explode(' - ',$request->get('daterange'));
		
		$start = date('Y-m-d',strtotime($daterange[0]));
		$end = date('Y-m-d',strtotime($daterange[1]));
		$reports1 = Receipt::with('adminInfo','donorInfo')->whereBetween('created_at', [$start." 00:00:00", $end." 23:59:59"]);
		
		if($request->has('batch_status') && !empty($request->get('batch_status')))
		{
		$reports1->where('batch_status',$request->get('batch_status'));
		}
		
		if($request->has('payment_mode') && !empty($request->get('payment_mode')))
		{
		$reports1->where('payment_mode',$request->get('payment_mode'));
		}
		
		//DB::enableQueryLog();
		$reports = $reports1->get();
		//dd(DB::getQueryLog());
		}
		else
		{
		$reports = '';
		}
		
		//dd($reports);
		
		$employees = Admin::where('status','1')->orderBy('created_at' , 'desc')->get();
        return view('admin.accounting.filter', compact('employees','reports'));
	}
	
	/**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function depositSlip(Request $request, $id)
    {
		$history = Accounting::with('adminInfo')->where('id',$id)->first();
		$deposit = Deposit::where('accounting_id',$id)->first();
		
		/*Auto Algorithm*/
		$receiptIds = explode(',',$history->receipt_ids);
		$receipts = Receipt::whereIn('id',$receiptIds)->get();
		
		$cash_total = '0.0';
		$cheque_total = '0.0';
		
		$cheque_arr = array();
		
		
		if(!empty($receipts))
		{
		foreach($receipts as $k=>$receipt)
		{
		if($receipt->payment_mode=='Cheque')
		{
		$cheque_total += $receipt->amount;
		$cheque_arr[$k] = array('cheque_details'=>$receipt->cheque_no,'cheque_amount'=>$receipt->amount);
		}
		else
		{
		$cash_total += $receipt->amount;
		}
		}
		}
		
		$cheque_array = array_values($cheque_arr);
		
		//dd($cheque_total);
		
		
		/*Auto Algorithm*/
		
		
        return view('admin.accounting.deposit-slip', compact('history','id','deposit','cheque_array','cash_total','cheque_total'));
    }
	
	
	
	/**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function depositSlipSave(Request $request)
    {
		$this->validate($request, [
				'accounting_id' => 'required',
				'bank_type' => 'required',
				'account_number' => 'required',
				'deposit_total' => 'required'
        	]);  
		
		
		
			
		
		
		try{
		
		
			$depositCount = Deposit::where('id',$request->deposit_id);
			
         	if($depositCount->count()>0)
			{
			$deposit = $depositCount->first();
			
			$deposit->bank_type = $request->bank_type;
			$deposit->account_number = $request->account_number;
			
			//$deposit->admin_id = Auth::guard('admin')->user()->id;
			$deposit->cash_type = (!empty($request->cash_type)) ? implode(',',array_filter($request->cash_type)) : '';
			$deposit->cash_amount = (!empty($request->cash_amount)) ? implode(',',array_filter($request->cash_amount)) : '';
			$deposit->cash_count = (!empty($request->cash_count)) ? implode(',',array_filter($request->cash_count)) : '';
			$deposit->cash_subtotal = $request->cash_subtotal;
			$deposit->cheque_subtotal = $request->cheque_subtotal;
			$deposit->deposit_total = $request->deposit_total;
			$deposit->save();
			}
			else
			{
			$deposit = $request->all();
			$deposit['admin_id'] = Auth::guard('admin')->user()->id;
			$deposit['serial_no'] = deposit_serial_no();
			$deposit['cash_type'] = (!empty($request->cash_type)) ? implode(',',array_filter($request->cash_type)) : '';
			$deposit['cash_amount'] = (!empty($request->cash_amount)) ? implode(',',array_filter($request->cash_amount)) : '';
			$deposit['cash_count'] = (!empty($request->cash_count)) ? implode(',',array_filter($request->cash_count)) : '';
			
			$deposit['cheque_nos'] = (!empty($request->cheque_nos)) ? implode(',',array_filter($request->cheque_nos)) : '';
			$deposit['cheque_amounts'] = (!empty($request->cheque_amounts)) ? implode(',',array_filter($request->cheque_amounts)) : '';
			
			
			//dd($deposit);
			$deposit = Deposit::create($deposit);
			}

            return  redirect()->route('admin.accounting.deposit.slip.print',['id'=>$deposit->id])->with('flash_success','Deposit Details Saved Successfully');   

        } 

        catch (Exception $e) {
            return back()->withInput()->with('flash_error', 'Something went wrong. Please try again later');
        }
		
		
		
	}
	
	
	
	/**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function depositSlipPrint($id)
    {
		$deposit = Deposit::where('id',$id)->first();		
        return view('admin.accounting.deposit-slip-print', compact('deposit'));
    }
	
	
	/**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function depositSlips(Request $request)
    {
	
	
		if($request->has('daterange'))
		{
		$daterange = explode(' - ',$request->get('daterange'));
		
		$start = date('Y-m-d',strtotime($daterange[0]));
		$end = date('Y-m-d',strtotime($daterange[1]));
		$reports1 = Deposit::whereBetween('created_at', [$start." 00:00:00", $end." 23:59:59"]);
		
		
		
		if($request->has('bank') && !empty($request->get('bank')))
		{
		if($request->get('bank')=='All')
		{
		}
		else
		{
		$reports1->where('bank_type',$request->get('bank'));
		}
		}
		
		//DB::enableQueryLog();
		$deposits = $reports1->get();
		//dd(DB::getQueryLog());
		}
		else
		{
		$deposits = '';
		}
	
	
	
		//$deposits = Deposit::orderBy('created_at' , 'desc')->get();
		
		
		
        return view('admin.accounting.deposit-slips', compact('deposits'));
    }
	
}
