<?php

namespace App\Http\Controllers\Resource;

use App\Models\Event;
//use App\UserRequests;
use Illuminate\Http\Request;
use App\Helpers\Helper;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use App\Http\Controllers\Controller;
use Exception;
use Storage;
//use Setting;
use DB;
use App\LoginActivity;

class EventResource extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('demo', ['only' => ['destroy']]);
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //$assistant = Event::orderBy('created_at' , 'desc')->toSql();
		//echo $assistant;
		
		$events = Event::orderBy('created_at' , 'desc')->get();
		//print_r($assistant);
		
		
        return view('admin.event.index', compact('events'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.event.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
			'title' => 'required|max:255'
        ]);          
        try{

            $admin = $request->all();
			$admin = Event::create($admin);

            return back()->with('flash_success','Event Details Saved Successfully');

        } 

        catch (Exception $e) {
            return back()->with('flash_error', 'Something went wrong. Please try again later');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        try {
            $admin = Event::findOrFail($id);
			$activities = LoginActivity::where('admin_id',$id)->orderBy('created_at','desc')->paginate(15);
            return view('admin.event.assistant-details', compact('admin','activities'));
        } catch (ModelNotFoundException $e) {
            return $e;
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $admin = Event::findOrFail($id);
            return view('admin.event.edit',compact('admin'));
        } catch (ModelNotFoundException $e) {
            return $e;
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'title' => 'required|max:255'
        ]);

        try {

            $event = Event::findOrFail($id);
            $event->title = $request->title;
			$event->description = $request->description;			
            $event->save();

            return redirect()->route('admin.event.index')->with('flash_success', 'Event details Updated Successfully');    
        } 

        catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'Event Not Found');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        
        try {

            Event::find($id)->delete();
			
            return back()->with('message', 'Event deleted successfully');
        } 
        catch (Exception $e) {
            return back()->with('flash_error', 'Event Not Found');
        }
    }

}
