<?php

namespace App\Http\Controllers\Resource;

use App\Models\Event;
use App\Models\Transaction;
//use App\UserRequests;
use Illuminate\Http\Request;
use App\Helpers\Helper;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use App\Http\Controllers\Controller;
use Exception;
use Storage;
//use Setting;
use DB;
use App\LoginActivity;
use Carbon\Carbon;
use Auth;

class TransactionResource extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('demo', ['only' => ['destroy']]);
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
		$qry = Transaction::query();
		
		/*if($request->has('status'))
		{
			$qry->where('response_code', trim($request->status));
		}*/
		if ($request->filled('status') && !empty(trim($request->status))) {
			$qry->where('response_code', trim($request->status));
		}	
		
		if($request->has('daterange'))
		{
		$daterange = explode(' - ',$request->get('daterange'));
		
		$start = date('Y-m-d',strtotime($daterange[0]));
		$end = date('Y-m-d',strtotime($daterange[1]));
		
		$qry->whereBetween('txt_date', [$start." 00:00:00", $end." 23:59:59"]);
		}
		
		/*if($request->has('keyword'))
		{
		$qry->where('cardholder_name', 'like', '%' . $request->keyword . '%')->orWhere('cardholder_email', 'like', '%' . $request->keyword . '%')->orWhere('operator', 'like', '%' . $request->operator . '%');
		}*/
		
		if ($request->has('keyword')) {
				$keyword = $request->get('keyword');
				$qry->where(function ($query) use ($keyword) {
					$query->where('cardholder_name', 'like', '%' . $keyword . '%')
						  ->orWhere('cardholder_email', 'like', '%' . $keyword . '%')
						  ->orWhere('operator', 'like', '%' . $keyword . '%');
				});
			}
		
		$transactions = $qry->orderBy('receipt_no' , 'desc')->get();
		
		//print_r($assistant);
		
		//dd($transactions->toSql());
		
		
        return view('admin.transaction.index', compact('transactions'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
		$events = Event::orderBy('id','desc')->get();
        return view('admin.transaction.create',compact('events'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
	
		$event_id = $request->event_id;	
	

            $res_status = $res_msg = ''; 
		
		
		 
    // Allowed mime types 
    $csvMimes = array('text/x-comma-separated-values', 'text/comma-separated-values', 'application/octet-stream', 'application/vnd.ms-excel', 'application/x-csv', 'text/x-csv', 'text/csv', 'application/csv', 'application/excel', 'application/vnd.msexcel'); 
     
    // Validate whether selected file is a CSV file 
    if(!empty($_FILES['csv_file']['name']) && in_array($_FILES['csv_file']['type'], $csvMimes)){ 
         
        // If the file is uploaded 
        if(is_uploaded_file($_FILES['csv_file']['tmp_name'])){ 
             
            // Open uploaded CSV file with read-only mode 
            $csvFile = fopen($_FILES['csv_file']['tmp_name'], 'r'); 
             
            // Skip the first line 
            fgetcsv($csvFile); 
            
			$count=0; 
            // Parse data from CSV file line by line 
            while(($line = fgetcsv($csvFile)) !== FALSE){ 
                $line_arr = !empty($line)?array_filter($line):''; 
                if(!empty($line_arr)){ 
                    // Get row data 
					/*print_r($line_arr);
					exit();*/
					
					if(!empty($line_arr[0])) 
					{
					$order_id   = isset($line_arr[0]) ? trim($line_arr[0]) : ''; 
                    $description  = isset($line_arr[1]) ? trim($line_arr[1]) : ''; 
                    $unique_ref  = isset($line_arr[2]) ? trim($line_arr[2]) : ''; 
                    //$txt_date = isset($line_arr[3]) ? trim($line_arr[3]) : ''; 
					$operator = isset($line_arr[4]) ? trim($line_arr[4]) : ''; 
					$amount = isset($line_arr[5]) ? trim($line_arr[5]) : ''; 
					$cardholder_name = isset($line_arr[6]) ? trim($line_arr[6]) : ''; 
					$cardholder_email = isset($line_arr[7]) ? trim($line_arr[7]) : ''; 
					$response_code = isset($line_arr[14]) ? trim($line_arr[14]) : ''; 
					$response_text = isset($line_arr[13]) ? trim($line_arr[13]) : '';
					
					$carbonDate = Carbon::createFromFormat('d-m-Y:H:i:s:000', $line_arr[3]);

					// Format the date to Y-m-d H:i:s
					$txt_date = $carbonDate->format('Y-m-d H:i:s');
					
					if($response_code=='A'){
					
					
					//dd($txt_date);
						
						$transaction = new Transaction();
						$transaction->receipt_no = getTransactionReceiptNo();
						$transaction->event_id = $event_id;
						$transaction->order_id = $order_id;
						$transaction->description = $description;
						$transaction->unique_ref = $unique_ref;
						$transaction->txt_date = $txt_date;
						$transaction->operator = $operator;
						$transaction->amount = $amount;
						$transaction->cardholder_name = $cardholder_name;
						$transaction->cardholder_email = $cardholder_email;
						$transaction->response_code = $response_code;
						$transaction->response_text = $response_text;
						$transaction->save();
						$count++;	
						}
											
					}
					
                } 
            } 
             
            // Close opened CSV file 
            fclose($csvFile); 
             
            $res_status = 'success'; 
            $res_msg = 'Members data ('.$count.') has been imported successfully.'; 
        }else{ 
            $res_status = 'danger'; 
            $res_msg = 'Something went wrong, please try again.'; 
        } 
    }else{ 
        $res_status = 'danger'; 
        $res_msg = 'Please select a valid CSV file.'; 
    } 
 

	if($res_status=='success')
	{
		return back()->with('flash_success',$res_msg);
	}
	else
	{
	return back()->with('flash_error',$res_msg);
	}

        
	
              
        /*try{} 

        catch (Exception $e) {
            return back()->with('flash_error', 'Something went wrong. Please try again later');
        }*/
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        try {
            $admin = Transaction::findOrFail($id);
			$activities = LoginActivity::where('admin_id',$id)->orderBy('created_at','desc')->paginate(15);
            return view('admin.transaction.assistant-details', compact('admin','activities'));
        } catch (ModelNotFoundException $e) {
            return $e;
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $transaction = Transaction::findOrFail($id);
            return view('admin.transaction.edit',compact('transaction'));
        } catch (ModelNotFoundException $e) {
            return $e;
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'email' => 'required',
			'contact_type' => 'required',
			'country_code' => 'required',
			'contact' => 'required',
			'address' => 'required',
			'postal_code' => 'required',
			'country' => 'required'
        ]);

        try {

			if(!empty($request->sent_remarks))
			{
			$sent_remarks = $request->sent_remarks;
			}
			else
			{
			$sent_remarks = "Receipt sent on ".date('Y-m-d h:i A')." by ".Auth::guard('admin')->user()->first_name.' '.Auth::guard('admin')->user()->last_name;
			}
            $transaction = Transaction::findOrFail($id);
            $transaction->cardholder_email = $request->email;
			$transaction->contact_type = $request->contact_type;
			$transaction->country_code = $request->country_code;
			$transaction->contact = $request->contact;
			$transaction->address = $request->address;
			$transaction->street_number = $request->street_number;
			$transaction->street_route = $request->street_route;
			$transaction->city = $request->city;
			$transaction->state = $request->state;
			$transaction->postal_code = $request->postal_code;
			$transaction->country = $request->country;	
			$transaction->created_at = $request->created_at;
			$transaction->is_sent = $request->is_sent;
			$transaction->sent_remarks = $sent_remarks;
            $transaction->save();

            return redirect()->route('admin.transaction.index')->with('flash_success', 'Transaction details Updated Successfully');    
        } 

        catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'Transaction Not Found');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        
        try {

            Transaction::find($id)->delete();
			
            return back()->with('message', 'Event deleted successfully');
        } 
        catch (Exception $e) {
            return back()->with('flash_error', 'Event Not Found');
        }
    }

}
