<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use App\Models\Admin;
use App\Models\Deposit;

class Accounting extends Authenticatable
{

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'admin_id','receipt_ids','total','note'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        
    ];

	
	public function adminInfo()
	{
		return $this->belongsTo(Admin::class,'admin_id','id'); 
	}
	
	public function depositInfo()
	{
		return $this->belongsTo(Deposit::class,'id','accounting_id'); 
	}
	
}
