<?php

require_once 'vendor/autoload.php';
require_once 'secrets.php';

\Stripe\Stripe::setApiKey($stripeSecretKey);
header('Content-Type: application/json');

$YOUR_DOMAIN = 'https://donation.gnfb.ca/public/stripe/';

$amount = isset($_POST['amount']) ? intval($_POST['amount']) : 1000; // Default to $10
/*$payment_intent = \Stripe\PaymentIntent::create([
    'amount' => $amount, // Amount in cents (e.g., 1000 = $10)
    'currency' => 'usd',
    'description' => 'Donation Payment',
]);*/

$checkout_session = \Stripe\Checkout\Session::create([
    'payment_method_types' => ['card'],
    'mode' => 'payment',
	'line_items' => [[
        'price_data' => [
            'currency' => 'usd',
            'product_data' => [
                'name' => 'Donation',
            ],
            'unit_amount' => $amount, // Amount in cents (e.g., 1000 = $10)
        ],
        'quantity' => 1, // Quantity of the item
    ]],
    'success_url' => $YOUR_DOMAIN . '/success.html',
    'cancel_url' => $YOUR_DOMAIN . '/cancel.html',
]);

header("HTTP/1.1 303 See Other");
header("Location: " . $checkout_session->url);