@extends('admin.includes.base')
<!--<script type="text/javascript" src="https://code.jquery.com/jquery-1.8.3.js"></script>-->
@push('styles')
<style>
.listitem {
    list-style: none;
	padding-left:0px;
}
.pr_list {
    border: 1px solid #ccc;
    margin: 6px;
    padding: 10px;
    background: #f8f8f8;
}
</style>
@endpush
@section('content')
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Events</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="{{ url('admin/home') }}">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Events</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  @include('common.notify')
  <div class="container-fluid">
    <div class="row">
      <div class="col-sm-12 col-md-8">
        <div class="card">
          <div class="card-body padd-10">
            <h4 class="card-title">Add Event</h4>
          </div>
          <hr class="m-t-0">
          <form class="form-horizontal r-separator" action="{{route('admin.event.store')}}" method="POST" enctype="multipart/form-data" role="form">
            {{csrf_field()}}
            <div class="card-body bg-light">
              <div>
                <div class="row">
                  <div class="col-12">
                    <div class="form-group">
                      <label for="inputEmail3" class="control-label col-form-label">Title<span class="asterrisk">*</span></label>
                      <input class="form-control" type="text" value="{{ old('title') }}" name="title" id="title" placeholder="Title" autocomplete="off">
                      @if ($errors->has('title')) <span class="help-block"> <strong>{{ $errors->first('title') }}</strong> </span> @endif </div>
                  </div>
                  <div class="col-12">
                    <div class="form-group">
                      <label for="inputEmail3" class="control-label col-form-label">Description<span class="asterrisk">*</span></label>
                      <textarea class="form-control" name="description" id="description" placeholder="Description" autocomplete="off">{{ old('description') }}</textarea>
                      @if ($errors->has('description')) <span class="help-block"> <strong>{{ $errors->first('description') }}</strong> </span> @endif </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="card-body">
              <div class="form-group m-b-0 text-right">
                <button type="submit" class="btn btn-info waves-effect waves-light">Save</button>
                <a href="{{route('admin.event.index')}}" class="btn btn-dark waves-effect waves-light deactive_button">Cancel</a> </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection