@extends('admin.includes.base')
<!--<script type="text/javascript" src="https://code.jquery.com/jquery-1.8.3.js"></script>-->
@push('styles')
<style>
.listitem {
    list-style: none;
	padding-left:0px;
}
.pr_list {
    border: 1px solid #ccc;
    margin: 6px;
    padding: 10px;
    background: #f8f8f8;
}
</style>
@endpush
@section('content')
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Transactions</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="{{ url('admin/home') }}">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Transactions</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  @include('common.notify')
  <div class="container-fluid">
    <div class="row">
      <div class="col-sm-12 col-md-8">
        <div class="card">
          <div class="card-body padd-10">
            <h4 class="card-title">Upload Transactions</h4>
          </div>
          <hr class="m-t-0">
          <form class="form-horizontal r-separator" action="{{route('admin.transaction.store')}}" method="POST" enctype="multipart/form-data" role="form">
            {{csrf_field()}}
            <div class="card-body bg-light">
              <div>
                <div class="row">
                  <div class="col-12">
                    <div class="form-group">
                      <label for="inputEmail3" class="control-label col-form-label">Event<span class="asterrisk">*</span></label>
                      <select class="form-control" name="event_id" id="event_id">
                        <option value="">--Select--</option>
					  @if(!empty($events))
					  @foreach($events as $event)
                        <option value="{{ $event->id }}" @if(old('event_id')==$event->id) selected="selected" @endif>{{ $event->title }}</option>
					  @endforeach
					  @endif					  
                      </select>
                      @if ($errors->has('event_id')) <span class="help-block"> <strong>{{ $errors->first('event_id') }}</strong> </span> @endif </div>
                  </div>
                  <div class="col-12">
                    <div class="form-group">
                      <label for="inputEmail3" class="control-label col-form-label">Upload CSV<span class="asterrisk">*</span></label>
                      <input type="file" class="form-control" name="csv_file">
                      <a href="{{ url('admin_assets/csv/format.csv') }}">Download Format</a> @if ($errors->has('csv_file')) <span class="help-block"> <strong>{{ $errors->first('csv_file') }}</strong> </span> @endif </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="card-body">
              <div class="form-group m-b-0 text-right">
                <button type="submit" class="btn btn-info waves-effect waves-light">Upload</button>
                <a href="{{route('admin.transaction.index')}}" class="btn btn-dark waves-effect waves-light deactive_button">Cancel</a> </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection