@extends('admin.includes.base')
@section('content')
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Transactions</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="{{ url('admin/home') }}">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Transactions</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  @include('common.notify')
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card bg-light">
          <div class="card-body">
            <form method="get" action="{{ route('admin.transaction.index') }}">
              <div class="row">
                <div class="col-md-3">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Keyword<span class="asterrisk">*</span></label>
                    <div class="clearfix"></div>
                    <input class="form-control" name="keyword" placeholder="Keyword" autocomplete="off" required value="{{ Request::get('keyword') }}">
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">From - To</label>
                    <div class="clearfix"></div>
                    <div class='input-group mb-3'>
                      <input type='text' class="form-control daterange" name="daterange" @if(Request::has('daterange')) value="{{ Request::get('daterange') }}" @endif autocomplete="off"/>
                      <div class="input-group-append"> <span class="input-group-text"> <span class="ti-calendar"></span> </span> </div>
                    </div>
                  </div>
                </div>
                <!--<div class="col-md-2">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Status</label>
                    <div class="clearfix"></div>
                    <select class="form-control" name="status">
                      <option value="">--Select--</option>
                      <option value="A" @if(Request::get('status')=='A') selected="selected" @endif>Approval</option>
                      <option value="D" @if(Request::get('status')=='D') selected="selected" @endif>Decline</option>
                    </select>
                  </div>
                </div>-->
                <div class="col-md-3">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">&nbsp;</label>
                    <div class='input-group mb-3'>
                      <button type="submit" class="btn btn-success"><i class="ti-filter"></i> Filter</button>&nbsp;<a href="{{ url('admin/transaction') }}" class="btn btn-danger"><i class="ti-reload"></i> Reset</a> </div>
                  </div>
                </div>
				<div class="col-md-2"></div>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col-lg-12">
        <div class="card bg-light">
          <div class="card-body">
            <div class="d-flex m-b-30 no-block">
              <h5 class="card-title m-b-0 align-self-center">View Transactions</h5>
              <div class="ml-auto">
                <div class="dl">
                  <div class="col-3 align-self-center"> <a class="btn btn-primary" href="{{ route('admin.transaction.create') }}"><i class="icon-Add"></i> Import Transactions</a> </div>
                </div>
              </div>
            </div>
            <div class="table-responsive">
              <table class="table bg-white table-bordered nowrap display file_export">
                <thead>
                  <tr>
                    <th>Receipt ID</th>
                    <th>Description</th>
                    <th>Operator</th>
                    <th>Amount</th>
                    <th>Cardholder Name</th>
                    <th>Cardholder Email</th>
                    <!--<th>Response</th>-->
					<th>Sent Status</th>
                    <th>Created On</th>					
                    <th class="noExport">Actions</th>
                  </tr>
                </thead>
                <tbody>
                @foreach($transactions as $index => $cat)
                <tr>
                  <td>{{ $cat->receipt_no }}</td>
                  <td>{{ $cat->description }}</td>
                  <td>{{ $cat->operator }}</td>
                  <td>{{ $cat->amount }}</td>
                  <td>{{ $cat->cardholder_name }}</td>
                  <td>{{ $cat->cardholder_email }}</td>
                  <!--<td> @if($cat->response_code=='A')
                    <label class="label label-success">Approval</label>
                    @else
                    <label class="label label-danger">Decline</label>
                    @endif </td>-->
				  <td>
				  @if($cat->is_sent=='1')
				  <span class="label label-success">Sent</span>
				  @else
				  <span class="label label-danger">Not Sent</span>
				  @endif
				  
				  </td>	
                  <th>{{ date('d/m/Y h:i A',strtotime($cat->txt_date)) }} </th>
                  <td><form action="{{ route('admin.transaction.destroy', $cat->id) }}" method="POST">
                      {{ csrf_field() }}
                      <input type="hidden" name="_method" value="DELETE">
					  
                      <a href="{{ route('admin.transaction.edit', $cat->id) }}" class="btn btn-warning btn-sm"><i class="fa fa-edit"></i></a> 
					  
					  <a href="{{ route('admin.receipt.print', ['id' => $cat->id, 'page' => 'transactions']) }}" class="btn btn-success btn-sm"><i class="fa fa-print"></i></a>
                      <button onclick="return confirm('Are you sure?')" class="btn btn-danger btn-sm"><i class="fa fa-trash-alt"></i> Delete</button>
                    </form></td>
                </tr>
                @endforeach
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection