
<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Donor Reports</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="<?php echo e(url('admin/home')); ?>">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Donor Reports</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php echo $__env->make('common.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card bg-light">
          <div class="card-body">
            <div class="d-flex m-b-30 no-block">
              <h5 class="card-title m-b-0 align-self-center">View Donor Reports</h5>
              <div class="ml-auto">
                <div class="dl">
                  <div class="col-3 align-self-center"> </div>
                </div>
              </div>
            </div>
            <form method="get" action="<?php echo e(route('admin.report.donor')); ?>">
              <div class="row">
                <div class="col-md-4">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Donor<span class="asterrisk">*</span></label>
                    <div class="clearfix"></div>
                    <select class="form-control" id="select2-donor" name="donor" style="width:100%;" required>
                      <option value="">Select Donor</option>
                      
					  <?php if(!empty($donors)): ?>
					  <?php $__currentLoopData = $donors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    
                      <option value="<?php echo e($customer->id); ?>" <?php if(Request::has('donor')): ?> <?php if(Request::get('donor')==$customer->id): ?> selected="selected" <?php endif; ?> <?php endif; ?>><?php echo e('#'.$customer->id.' - '.$customer->first_name.' '.$customer->last_name); ?></option>
                      
                    
                    
					  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					  <?php endif; ?>
                    
                  
                  
                    </select>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">From - To<span class="asterrisk">*</span></label>
                    <div class="clearfix"></div>
                    <div class='input-group mb-3'>
                      <input type='text' class="form-control daterange" name="daterange" required <?php if(Request::has('daterange')): ?> value="<?php echo e(Request::get('daterange')); ?>" <?php endif; ?> autocomplete="off"/>
                      <div class="input-group-append"> <span class="input-group-text"> <span class="ti-calendar"></span> </span> </div>
                    </div>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">&nbsp;</label>
                    <div class='input-group mb-3'>
                      <button type="submit" class="btn btn-success"><i class="ti-filter"></i> Filter</button>
                    </div>
                  </div>
                </div>
              </div>
            </form>
            <?php if(Request::has('donor') && Request::has('daterange')): ?>
			<?php if(!empty($reports)): ?>
            <div class="table-responsive">
              <table class="table bg-white table-bordered nowrap display file_export">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Receipt ID</th>
                    <th>Donor Name</th>
                    <th>Donor Contact</th>
                    <th>Amount</th>
                    <th>Payment Method</th>
                    <th>Payment Status</th>
                    <th>Collected By</th>
					<th>Batch Status</th>
					<th>Batch Closed By</th>
					<th>Batch Closed On</th>
                    <th>Donated On</th>
                  </tr>
                </thead>
                <tbody>
                
                <?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $receipt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td><?php echo e($index + 1); ?></td>
                  <td><?php echo e($receipt->receipt_no); ?></td>
                  <?php if(!empty($receipt->donorInfo)): ?>
                  <td><?php echo e($receipt->donorInfo->first_name.' '.$receipt->donorInfo->last_name); ?></td>
                  <td><?php echo e($receipt->donorInfo->contact); ?></td>
                  <?php else: ?>
                  <td>-</td>
                  <td>-</td>
                  <?php endif; ?>
                  <td>$ <?php echo e($receipt->amount); ?></td>
                  <td><?php echo e($receipt->payment_mode); ?></td>
                  <td><?php if($receipt->payment_status=='Paid'): ?> <span class="label label-success">Paid
              </span>
              <?php else: ?> <span class="label label-danger">Not Paid
              </span>
              <?php endif; ?></td>
                  <td><?php echo e($receipt->adminInfo->name); ?></td>
				  <td><?php if($receipt->batch_status=='Open'): ?> <span class="label label-success">Open
              </span>
              <?php else: ?> <span class="label label-danger">Closed
              </span>
              <?php endif; ?></td>
			  		
					<?php if($receipt->batch_status=='Closed'): ?>
					<td><?php echo e($receipt->batchAdminInfo->name); ?></td>
					<td><?php echo e(date('d/m/Y',strtotime($receipt->batch_updated_on))); ?></td>
					<?php else: ?>
					<td>-</td>
					<td>-</td>
					<?php endif; ?>
                  <td><?php echo e(date('d/m/Y',strtotime($receipt->created_at))); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                
              </table>
            </div>
			<?php endif; ?>
            <?php endif; ?> </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.includes.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/donationgnfb/public_html/resources/views/admin/report/donor-report.blade.php ENDPATH**/ ?>