<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Donation Users</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="<?php echo e(url('admin/home')); ?>">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Donation Users</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php echo $__env->make('common.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card bg-light">
          <div class="card-body">
            <div class="d-flex m-b-30 no-block">
              <h5 class="card-title m-b-0 align-self-center">View Donation Users</h5>
              <div class="ml-auto">
                <div class="dl">
                  <div class="col-3 align-self-center"> <a class="btn btn-primary addRecord" href="javascript:;"><i class="icon-Add"></i> Add Donation User</a> </div>
                </div>
              </div>
            </div>
            <div class="table-responsive">			
              <table class="table bg-white table-bordered nowrap display file_export">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Full Name</th>
					<th>Email Address</th>
					<th>Contact Number</th>
                    <th>Postal Code</th>
					<th>Joined On</th>
                    <th class="noExport">Actions</th>
                  </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $donors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $donor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td><?php echo e($index + 1); ?></td>
                  <td><?php echo e($donor->first_name.' '.$donor->last_name); ?></td>
				  <td><a href="mailto:<?php echo e($donor->email); ?>"><?php echo e($donor->email); ?></a></td>
                  <td><?php echo e($donor->contact); ?></td>
				  <td><?php echo e($donor->postal_code); ?></td>
				  <td><?php echo e(date('d/m/Y',strtotime($donor->created_at))); ?></td>
                  <!--<td><?php if($donor->status=='1'): ?> <a href="<?php echo e(route('admin.donor.uptStatus', ['id'=>$donor->id,'status'=>'0'])); ?>" class="label label-success">Active</a> <?php else: ?> <a href="<?php echo e(route('admin.donor.uptStatus', ['id'=>$donor->id,'status'=>'1'])); ?>" class="label label-danger">Inactive</a> <?php endif; ?></td>-->
                  <td><form action="<?php echo e(route('admin.donor.destroy', $donor->id)); ?>" method="POST">
                      <?php echo e(csrf_field()); ?>

                      <input type="hidden" name="_method" value="DELETE">
                      <!--<a href="<?php echo e(route('admin.donor.show', $donor->id)); ?>" class="btn btn-primary btn-sm"><i class="fas fa-eye" title="View"></i></a>--> <!--<a href="<?php echo e(route('admin.donor.edit', $donor->id)); ?>" class="btn btn-info btn-sm"><i class="fa fa-edit"></i> Edit</a>-->
					  <?php if(Auth::guard('admin')->user()->utype=='Super'): ?>
					  <a href="javascript:;" class="btn btn-info btn-sm editRecord" data-id="<?php echo e($donor->id); ?>"><i class="fa fa-edit"></i> Edit</a>
					  <?php else: ?>
					  <?php endif; ?>
					  
					  
                      <button onclick="return confirm('Are you sure?')" class="btn btn-danger btn-sm"><i class="fa fa-trash-alt"></i> Delete</button>
                    </form></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('modals'); ?>
<?php echo $__env->make('admin.donor.partials.addDonorModal',['module'=>'donor'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.includes.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/donationgnfb/public_html/resources/views/admin/donor/index.blade.php ENDPATH**/ ?>