
<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Transactions</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="<?php echo e(url('admin/home')); ?>">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Transactions</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php echo $__env->make('common.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card bg-light">
          <div class="card-body">
            <form method="get" action="<?php echo e(route('admin.transaction.index')); ?>">
              <div class="row">
                <div class="col-md-3">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Keyword<span class="asterrisk">*</span></label>
                    <div class="clearfix"></div>
                    <input class="form-control" name="keyword" placeholder="Keyword" autocomplete="off" required value="<?php echo e(Request::get('keyword')); ?>">
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">From - To</label>
                    <div class="clearfix"></div>
                    <div class='input-group mb-3'>
                      <input type='text' class="form-control daterange" name="daterange" <?php if(Request::has('daterange')): ?> value="<?php echo e(Request::get('daterange')); ?>" <?php endif; ?> autocomplete="off"/>
                      <div class="input-group-append"> <span class="input-group-text"> <span class="ti-calendar"></span> </span> </div>
                    </div>
                  </div>
                </div>
                <!--<div class="col-md-2">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Status</label>
                    <div class="clearfix"></div>
                    <select class="form-control" name="status">
                      <option value="">--Select--</option>
                      <option value="A" <?php if(Request::get('status')=='A'): ?> selected="selected" <?php endif; ?>>Approval</option>
                      <option value="D" <?php if(Request::get('status')=='D'): ?> selected="selected" <?php endif; ?>>Decline</option>
                    </select>
                  </div>
                </div>-->
                <div class="col-md-3">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">&nbsp;</label>
                    <div class='input-group mb-3'>
                      <button type="submit" class="btn btn-success"><i class="ti-filter"></i> Filter</button>&nbsp;<a href="<?php echo e(url('admin/transaction')); ?>" class="btn btn-danger"><i class="ti-reload"></i> Reset</a> </div>
                  </div>
                </div>
				<div class="col-md-2"></div>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col-lg-12">
        <div class="card bg-light">
          <div class="card-body">
            <div class="d-flex m-b-30 no-block">
              <h5 class="card-title m-b-0 align-self-center">View Transactions</h5>
              <div class="ml-auto">
                <div class="dl">
                  <div class="col-3 align-self-center"> <a class="btn btn-primary" href="<?php echo e(route('admin.transaction.create')); ?>"><i class="icon-Add"></i> Import Transactions</a> </div>
                </div>
              </div>
            </div>
            <div class="table-responsive">
              <table class="table bg-white table-bordered nowrap display file_export">
                <thead>
                  <tr>
                    <th>Receipt ID</th>
                    <th>Description</th>
                    <th>Operator</th>
                    <th>Amount</th>
                    <th>Cardholder Name</th>
                    <th>Cardholder Email</th>
                    <!--<th>Response</th>-->
					<th>Sent Status</th>
                    <th>Created On</th>					
                    <th class="noExport">Actions</th>
                  </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td><?php echo e($cat->receipt_no); ?></td>
                  <td><?php echo e($cat->description); ?></td>
                  <td><?php echo e($cat->operator); ?></td>
                  <td><?php echo e($cat->amount); ?></td>
                  <td><?php echo e($cat->cardholder_name); ?></td>
                  <td><?php echo e($cat->cardholder_email); ?></td>
                  <!--<td> <?php if($cat->response_code=='A'): ?>
                    <label class="label label-success">Approval</label>
                    <?php else: ?>
                    <label class="label label-danger">Decline</label>
                    <?php endif; ?> </td>-->
				  <td>
				  <?php if($cat->is_sent=='1'): ?>
				  <span class="label label-success">Sent</span>
				  <?php else: ?>
				  <span class="label label-danger">Not Sent</span>
				  <?php endif; ?>
				  
				  </td>	
                  <th><?php echo e(date('d/m/Y h:i A',strtotime($cat->txt_date))); ?> </th>
                  <td><form action="<?php echo e(route('admin.transaction.destroy', $cat->id)); ?>" method="POST">
                      <?php echo e(csrf_field()); ?>

                      <input type="hidden" name="_method" value="DELETE">
					  
                      <a href="<?php echo e(route('admin.transaction.edit', $cat->id)); ?>" class="btn btn-warning btn-sm"><i class="fa fa-edit"></i></a> 
					  
					  <a href="<?php echo e(route('admin.receipt.print', ['id' => $cat->id, 'page' => 'transactions'])); ?>" class="btn btn-success btn-sm"><i class="fa fa-print"></i></a>
                      <button onclick="return confirm('Are you sure?')" class="btn btn-danger btn-sm"><i class="fa fa-trash-alt"></i> Delete</button>
                    </form></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.includes.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/donationgnfb/public_html/resources/views/admin/transaction/index.blade.php ENDPATH**/ ?>