<?php $__env->startPush('styles'); ?>
<style>
.table td
{
padding: 15px 10px!important;
}
</style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Deposit Slips</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="<?php echo e(url('admin/home')); ?>">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Deposit Slips</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php echo $__env->make('common.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card bg-light">
          <div class="card-body">
		  
		  
		  <form method="get" action="<?php echo e(route('admin.accounting.deposit.slips')); ?>">
              <div class="row">
			  <div class="col-md-3">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Bank</label>
                    <div class="clearfix"></div>
                    <select class="form-control" name="bank" style="width:100%;">
                      <option value="All" <?php if(Request::has('bank') && Request::get('bank')=="All"): ?> selected="selected" <?php endif; ?>>All</option>
                      <option value="Canada Trust" <?php if(Request::has('bank') && Request::get('bank')=="Canada Trust"): ?> selected="selected" <?php endif; ?>>Canada Trust</option>
              <option value="Khalsa Credit Union" <?php if(Request::has('bank') && Request::get('bank')=="Khalsa Credit Union"): ?> selected="selected" <?php endif; ?>>Khalsa Credit Union</option>
              
                    </select>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">From - To<span class="asterrisk">*</span></label>
                    <div class="clearfix"></div>
                    <div class='input-group mb-3'>
                      <input type='text' class="form-control daterange" name="daterange" required <?php if(Request::has('daterange')): ?> value="<?php echo e(Request::get('daterange')); ?>" <?php endif; ?> autocomplete="off"/>
                      <div class="input-group-append"> <span class="input-group-text"> <span class="ti-calendar"></span> </span> </div>
                    </div>
                  </div>
                </div>
                <div class="col-md-2">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">&nbsp;</label>
                    <div class='input-group mb-3'>
                      <button type="submit" class="btn btn-success"><i class="ti-filter"></i> Filter</button>
                    </div>
                  </div>
                </div>
              </div>
            </form>
		  
		  
            <?php if(!empty($deposits)): ?>
            <div class="table-responsive">
              <table class="table bg-white table-bordered nowrap display file_export_report">
                <thead>
                  <tr>
                    <th>Sr. No.</th>
                    <th>Bank</th>
                    <th>Deposit Total</th>
					<th>Notes</th>
					<th>Date</th>
					<th>Action</th>
                  </tr>
                </thead>
                <tbody>
                
                <?php $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td><?php echo e($deposit->serial_no); ?></td>
                  <td><?php echo e($deposit->bank_type); ?></td>
				  <td><?php echo e(currency().$deposit->deposit_total); ?></td>
				  <td><?php echo e($deposit->notes ?? '-'); ?></td>
				  <td><?php echo e(date('d/m/Y',strtotime($deposit->created_at))); ?></td>
				  <td><a href="<?php echo e(route('admin.accounting.deposit.slip.print', $deposit->id)); ?>" class="btn btn-success btn-sm"><i class="fa fa-print"></i></a></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>
            <?php endif; ?></div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.includes.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/donationgnfb/public_html/resources/views/admin/accounting/deposit-slips.blade.php ENDPATH**/ ?>