<?php

namespace App\Http\Controllers\Resource;

use App\Models\Admin;
//use App\UserRequests;
use Illuminate\Http\Request;
use App\Helpers\Helper;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use App\Http\Controllers\Controller;
use Exception;
use Storage;
//use Setting;
use DB;
use App\LoginActivity;

class AdminResource extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('demo', ['only' => ['destroy']]);
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //$assistant = Admin::orderBy('created_at' , 'desc')->toSql();
		//echo $assistant;
		
		$admins = Admin::where('id','!=','1')->orderBy('created_at' , 'desc')->get();
		//print_r($assistant);
		
		
        return view('admin.admin.index', compact('admins'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.admin.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
			'first_name' => 'required|max:255',
			'last_name' => 'required|max:255',
			'email' => 'required|email|max:255|unique:admins',
            'password' => 'required|min:6',
			'contact' => 'required|max:255',
			//"permissions"  => "required|array",
			"role" => 'required|max:255'
        ]);          
        try{

            $admin = $request->all();
			
			/*$admin['first_name'] = $request->first_name; 
			$admin['last_name'] = $request->last_name; 
			$admin['contact'] = $request->contact;*/
			$admin['name'] = $request->first_name.' '.$request->last_name; 
			$admin['password'] = bcrypt($request->password);           
            if($request->hasFile('picture')) {
                $admin['picture'] = $request->picture->store('admin/profile');
            }
			
			/*$permission = $request->permissions;
			
			$permissions = array_map(function($value) {
			   return $value === "" ? 'No' : $value;
			}, $permission); 
			
			//dd($permissions);
			
			$admin['permissions'] = implode(',',$permissions);*/
			$admin['utype'] = $request->role;   
			$admin = Admin::create($admin);

            return back()->with('flash_success','Staff Member Details Saved Successfully');

        } 

        catch (Exception $e) {
            return back()->with('flash_error', 'Something went wrong. Please try again later');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        try {
            $admin = Admin::findOrFail($id);
			$activities = LoginActivity::where('admin_id',$id)->orderBy('created_at','desc')->paginate(15);
            return view('admin.admin.assistant-details', compact('admin','activities'));
        } catch (ModelNotFoundException $e) {
            return $e;
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $admin = Admin::findOrFail($id);
            return view('admin.admin.edit',compact('admin'));
        } catch (ModelNotFoundException $e) {
            return $e;
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'first_name' => 'required|max:255',
			'last_name' => 'required|max:255',
			'email' => 'required|email|max:255|unique:admins,email,'.$id,
            'password' => 'nullable|min:6',
			'contact' => 'required|max:255',
			//'about' => 'required',
            'picture' => 'mimes:jpeg,jpg,bmp,png|max:5242880',
			"role" => 'required|max:255'
        ]);

        try {

            $admin = Admin::findOrFail($id);
			
			if($request->hasFile('picture')) {
                (!empty($admin->picture)) ?? Storage::delete($admin->picture);
                $admin->picture = $request->picture->store('admin/profile');
            }
			$admin->name = $request->first_name.' '.$request->last_name; 
            $admin->first_name = $request->first_name;
			$admin->last_name = $request->last_name;
            $admin->email = $request->email;
			
			$admin->contact = $request->contact;
			/*$permission = $request->permissions;
			
			$permissions = array_map(function($value) {
			   return $value === "" ? 'No' : $value;
			}, $permission); 
			
			$admin->permissions = implode(',',$permissions);*/
			$admin->utype = $request->role;
						          
								  
            if($request->has('password')) {
                $admin->password = bcrypt($request->password); 
            }
			
            $admin->save();

            return redirect()->route('admin.admin.index')->with('flash_success', 'Staff Member Updated Successfully');    
        } 

        catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'Staff Member Not Found');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        
        try {

            Admin::find($id)->delete();
			
            return back()->with('message', 'Staff Member deleted successfully');
        } 
        catch (Exception $e) {
            return back()->with('flash_error', 'Staff Member Not Found');
        }
    }

}
