<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use App\Models\Admin;

class Deposit extends Authenticatable
{

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'serial_no','admin_id','accounting_id','bank_type','account_number','cash_type','cash_amount','cash_count','cash_subtotal','cheque_nos','cheque_amounts','cheque_subtotal','deposit_total','notes'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        
    ];

	
	public function adminInfo()
	{
		return $this->belongsTo(Admin::class,'admin_id','id'); 
	}
	
}
