@extends('admin.includes.base')
@section('content')
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Donors</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="{{ url('admin/home') }}">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Donors</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  @include('common.notify')
  <div class="container-fluid">
    <div class="row">
      <div class="col-8">
        <div class="card">
          <div class="card-body padd-10">
            <h4 class="card-title">Add Donor</h4>
          </div>
          <hr class="m-t-0">
          <form class="form-horizontal r-separator" action="{{route('admin.donor.store')}}" method="POST" enctype="multipart/form-data" role="form" id="donorForm">
            {{csrf_field()}}
            <div class="card-body bg-light">
              <div class="row">
                <div class="col-8">
                  <div class="row">
                    <div class="col-6">
                      <div class="form-group">
                        <label for="inputEmail3" class="control-label col-form-label">First Name<span class="asterrisk">*</span></label>
                        <input type="text" class="form-control" id="inputEmail3" name="first_name" value="{{ old('first_name') }}">
                        @if ($errors->has('first_name')) <span class="help-block"> <strong>{{ $errors->first('first_name') }}</strong> </span> @endif </div>
                    </div>
                    <div class="col-6">
                      <div class="form-group">
                        <label for="inputEmail3" class="control-label col-form-label">Last Name<span class="asterrisk">*</span></label>
                        <input type="text" class="form-control" id="inputEmail3" name="last_name" value="{{ old('last_name') }}">
                        @if ($errors->has('last_name')) <span class="help-block"> <strong>{{ $errors->first('last_name') }}</strong> </span> @endif </div>
                    </div>
                  </div>
                </div>
                <div class="col-4">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Email Address<span class="asterrisk">*</span></label>
                    <input type="email" class="form-control" id="inputEmail3" name="email" value="{{ old('email') }}">
                    @if ($errors->has('email')) <span class="help-block"> <strong>{{ $errors->first('email') }}</strong> </span> @endif </div>
                </div>
                <div class="col-6">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Contact Number<span class="asterrisk">*</span></label>
                    <div class="row">
                      <div class="col-4">
                        <select class="form-control" name="contact_type">
                          <option value="Cell" @if(old('contact_type')=='Cell') selected="selected" @endif>Cell</option>
                          <option value="Home" @if(old('contact_type')=='Home') selected="selected" @endif>Home</option>
                          <option value="Office" @if(old('contact_type')=='Office') selected="selected" @endif>Office</option>
                        </select>
                      </div>
                      <div class="phone-div col-8">
                        <input type="hidden" name="country_code" class="country_code" value="{{ old('country_code') ?? '1' }}"/>
                        <input type="text" class="form-control phone" id="phone" name="contact" value="{{ old('contact') }}">
                        @if ($errors->has('contact')) <span class="help-block"> <strong>{{ $errors->first('contact') }}</strong> </span> @endif </div>
                    </div>
                  </div>
                </div>
                <div class="col-6">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Alternate Contact Number<span class="asterrisk">*</span></label>
                    <div class="row">
                      <div class="col-4">
                        <select class="form-control" name="alternate_contact_type">
                          <option value="Cell" @if(old('alternate_contact_type')=='Cell') selected="selected" @endif>Cell</option>
                          <option value="Home" @if(old('alternate_contact_type')=='Home') selected="selected" @endif>Home</option>
                          <option value="Office" @if(old('alternate_contact_type')=='Office') selected="selected" @endif>Office</option>
                        </select>
                      </div>
                      <div class="phone-div col-8">
                        <input type="hidden" name="alternate_country_code" class="country_code" value="{{ old('alternate_country_code') ?? '1' }}"/>
                        <input type="text" class="form-control phone" id="phone" name="alternate_contact" value="{{ old('alternate_contact') }}">
                        @if ($errors->has('alternate_contact')) <span class="help-block"> <strong>{{ $errors->first('alternate_contact') }}</strong> </span> @endif </div>
                    </div>
                  </div>
                </div>
                <div class="col-6">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Address<span class="asterrisk">*</span></label>
                    <input id="autocomplete" placeholder="Enter Address" type="text" class="form-control" name="address" value="{{ old('address') }}">
                    <!--<textarea class="form-control" id="inputEmail3" name="address">{{ old('address') }}</textarea>-->
                    @if ($errors->has('address')) <span class="help-block"> <strong>{{ $errors->first('address') }}</strong> </span> @endif </div>
                </div>
                <!--<div id="address">
      <div class="row">
         <div class="col-md-6">
            <label class="control-label">Street address</label>
            <input class="form-control" id="street_number" disabled="true">
         </div>
         <div class="col-md-6">
            <label class="control-label">Route</label>
            <input class="form-control" id="route" disabled="true">
         </div>
      </div>
      <div class="row">
         <div class="col-md-6">
            <label class="control-label">City</label>
            <input class="form-control field" id="locality" disabled="true">
         </div>
         <div class="col-md-6"> 
            <label class="control-label">State</label>
            <input class="form-control" id="administrative_area_level_1" disabled="true">
         </div>
      </div>
      <div class="row">
         <div class="col-md-6">
            <label class="control-label">Zip code</label>
            <input class="form-control" id="postal_code" disabled="true">
         </div>
         <div class="col-md-6">
            <label class="control-label">Country</label>
            <input class="form-control" id="country" disabled="true">
         </div>
      </div>
   </div>-->
                <div class="col-6">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Postal Code<span class="asterrisk">*</span></label>
                    <input type="text" class="form-control" id="inputEmail3" name="postal_code" value="{{ old('postal_code') }}">
                    @if ($errors->has('postal_code')) <span class="help-block"> <strong>{{ $errors->first('postal_code') }}</strong> </span> @endif </div>
                </div>
              </div>
            </div>
            <div class="card-body">
              <div class="form-group m-b-0 text-right">
                <button type="submit" class="btn btn-info waves-effect waves-light">Save</button>
                <a href="{{route('admin.donor.index')}}" class="btn btn-dark waves-effect waves-light deactive_button">Cancel</a> </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection

@section('scripts')
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAWjv_B5Ug9dxwMc9ig9dr1AjReKMvjZxE&libraries=places&callback=initAutocomplete" async defer></script>
<script type="text/javascript">//<![CDATA[


var placeSearch, autocomplete;
      var componentForm = {
        street_number: 'short_name',
        route: 'long_name',
        locality: 'long_name',
        administrative_area_level_1: 'short_name',
        country: 'long_name',
        postal_code: 'short_name'
      };

      function initAutocomplete() {
        // Create the autocomplete object, restricting the search to geographical
        // location types.
        autocomplete = new google.maps.places.Autocomplete(
            /** @type {!HTMLInputElement} */(document.getElementById('autocomplete')),
            {types: ['geocode']});

        // When the user selects an address from the dropdown, populate the address
        // fields in the form.
        autocomplete.addListener('place_changed', fillInAddress);
      }

      function fillInAddress() {
        // Get the place details from the autocomplete object.
        var place = autocomplete.getPlace();

        for (var component in componentForm) {
          document.getElementById(component).value = '';
          document.getElementById(component).disabled = false;
        }

        // Get each component of the address from the place details
        // and fill the corresponding field on the form.
        for (var i = 0; i < place.address_components.length; i++) {
          var addressType = place.address_components[i].types[0];
          if (componentForm[addressType]) {
            var val = place.address_components[i][componentForm[addressType]];
            document.getElementById(addressType).value = val;
          }
        }
      }

      // Bias the autocomplete object to the user's geographical location,
      // as supplied by the browser's 'navigator.geolocation' object.
      /*function geolocate() {
        if (navigator.geolocation) {
          navigator.geolocation.getCurrentPosition(function(position) {
            var geolocation = {
              lat: position.coords.latitude,
              lng: position.coords.longitude
            };
            var circle = new google.maps.Circle({
              center: geolocation,
              radius: position.coords.accuracy
            });
            autocomplete.setBounds(circle.getBounds());
          });
        }
      }*/


  //]]></script>
@endsection