<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Flex
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\FlexApi\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;
use Twilio\InstanceContext;


class InsightsSegmentsContext extends InstanceContext
    {
    /**
     * Initialize the InsightsSegmentsContext
     *
     * @param Version $version Version that contains the resource
     * @param string $segmentId To unique id of the segment
     */
    public function __construct(
        Version $version,
        $segmentId
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'segmentId' =>
            $segmentId,
        ];

        $this->uri = '/Insights/Segments/' . \rawurlencode($segmentId)
        .'';
    }

    /**
     * Fetch the InsightsSegmentsInstance
     *
     * @param array|Options $options Optional Arguments
     * @return InsightsSegmentsInstance Fetched InsightsSegmentsInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(array $options = []): InsightsSegmentsInstance
    {

        $options = new Values($options);

        $headers = Values::of(['Token' => $options['token']]);

        $payload = $this->version->fetch('GET', $this->uri, [], [], $headers);

        return new InsightsSegmentsInstance(
            $this->version,
            $payload,
            $this->solution['segmentId']
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.FlexApi.V1.InsightsSegmentsContext ' . \implode(' ', $context) . ']';
    }
}
