<?php

namespace App\Http\Controllers\Resource;

use App\Models\Setting;
//use App\UserRequests;
use Illuminate\Http\Request;
use App\Helpers\Helper;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use App\Http\Controllers\Controller;
use Exception;
use Storage;
//use Setting;
use DB;

class SettingResource extends Controller
{ 
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('demo', ['only' => ['destroy']]);
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //$setting = Setting::orderBy('created_at' , 'desc')->toSql();
		//echo $setting;
		
		$setting = Setting::findOrFail(1);
		//print_r($setting);
		
		
        return view('admin.setting.index', compact('setting'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.setting.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:settings|max:255',
            'designation' => 'required',
            'picture ' => 'mimes:jpeg,jpg,bmp,png|max:5242880',
			'description' => 'required',
        ]);

        try{

            $setting = $request->all();
			
			if($request->hasFile('picture')) {
                $setting['picture'] = $request->picture->store('setting');
            }
           
           
			$setting = Setting::create($setting);
            //$setting = Setting::create($setting)->toSql();

			
			//dd($setting);
			//exit();

            return back()->with('flash_success','Settings Details Saved Successfully');

        } 

        catch (Exception $e) {
            return back()->with('flash_error', 'Something went wrong. Please try again later');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        try {
            $user = Setting::findOrFail($id);
            return view('admin.setting.edit', compact('user'));
        } catch (ModelNotFoundException $e) {
            return $e;
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $setting = Setting::findOrFail($id);
            return view('admin.setting.edit',compact('setting'));
        } catch (ModelNotFoundException $e) {
            return $e;
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'stitle' => 'required|max:255',
			'metakey' => 'required',
			'metadesc' => 'required',
			'address' => 'required',
			'contact' => 'required',
			'email' => 'required',
			'website' => 'required',
			'facebook' => 'required',
			'twitter' => 'required',
			'linkedin' => 'required',
			'gplus' => 'required',
        ]);
			$setting = Setting::findOrFail($id);
			$setting->stitle = $request->stitle;
			$setting->metakey = $request->metakey;
			$setting->metadesc = $request->metadesc;
			$setting->address = $request->address;
			$setting->contact = $request->contact;
			$setting->email = $request->email;
			$setting->website = $request->website;
			$setting->facebook = $request->facebook;
			$setting->twitter = $request->twitter;
			$setting->linkedin = $request->linkedin;
			$setting->gplus = $request->gplus;
			$setting->prospect_message = $request->prospect_message;
			
            $setting->save();

            return redirect()->route('admin.setting.index')->with('flash_success', 'Settings Updated Successfully');    
        
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        
        try {

            Setting::find($id)->delete();
            return back()->with('message', 'Settings deleted successfully');
        } 
        catch (Exception $e) {
            return back()->with('flash_error', 'Settings Not Found');
        }
    }

}
