<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\Admin;
use App\Models\Donor;

class Receipt extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'admin_id','receipt_no', 'donor_id', 'amount','payment_mode','card_number','cheque_no','cheque_date','pledge_date','payment_frequency','payment_status','remarks'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [];
	
	
	public function adminInfo() {
    	return $this->belongsTo(Admin::class,'admin_id','id'); 
	}
	
	public function donorInfo() {
    	return $this->belongsTo(Donor::class,'donor_id','id'); 
	}
	
	public function batchAdminInfo() {
    	return $this->belongsTo(Admin::class,'batch_updated_by','id'); 
	}
	
	
	
}
