@extends('admin.includes.base')
@push('styles')
<style>
.table td
{
padding: 15px 10px!important;
}
</style>
@endpush
@section('content')
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Deposit Slips</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="{{ url('admin/home') }}">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Deposit Slips</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  @include('common.notify')
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card bg-light">
          <div class="card-body">
		  
		  
		  <form method="get" action="{{ route('admin.accounting.deposit.slips') }}">
              <div class="row">
			  <div class="col-md-3">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Bank</label>
                    <div class="clearfix"></div>
                    <select class="form-control" name="bank" style="width:100%;">
                      <option value="All" @if(Request::has('bank') && Request::get('bank')=="All") selected="selected" @endif>All</option>
                      <option value="Canada Trust" @if(Request::has('bank') && Request::get('bank')=="Canada Trust") selected="selected" @endif>Canada Trust</option>
              <option value="Khalsa Credit Union" @if(Request::has('bank') && Request::get('bank')=="Khalsa Credit Union") selected="selected" @endif>Khalsa Credit Union</option>
              
                    </select>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">From - To<span class="asterrisk">*</span></label>
                    <div class="clearfix"></div>
                    <div class='input-group mb-3'>
                      <input type='text' class="form-control daterange" name="daterange" required @if(Request::has('daterange')) value="{{ Request::get('daterange') }}" @endif autocomplete="off"/>
                      <div class="input-group-append"> <span class="input-group-text"> <span class="ti-calendar"></span> </span> </div>
                    </div>
                  </div>
                </div>
                <div class="col-md-2">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">&nbsp;</label>
                    <div class='input-group mb-3'>
                      <button type="submit" class="btn btn-success"><i class="ti-filter"></i> Filter</button>
                    </div>
                  </div>
                </div>
              </div>
            </form>
		  
		  
            @if(!empty($deposits))
            <div class="table-responsive">
              <table class="table bg-white table-bordered nowrap display file_export_report">
                <thead>
                  <tr>
                    <th>Sr. No.</th>
                    <th>Bank</th>
                    <th>Deposit Total</th>
					<th>Notes</th>
					<th>Date</th>
					<th>Action</th>
                  </tr>
                </thead>
                <tbody>
                
                @foreach($deposits as $index => $deposit)
                <tr>
                  <td>{{ $deposit->serial_no }}</td>
                  <td>{{ $deposit->bank_type }}</td>
				  <td>{{ currency().$deposit->deposit_total }}</td>
				  <td>{{ $deposit->notes ?? '-' }}</td>
				  <td>{{ date('d/m/Y',strtotime($deposit->created_at)) }}</td>
				  <td><a href="{{ route('admin.accounting.deposit.slip.print', $deposit->id) }}" class="btn btn-success btn-sm"><i class="fa fa-print"></i></a></td>
                </tr>
                @endforeach
                </tbody>
              </table>
            </div>
            @endif</div>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection
