@extends('admin.includes.base')
@section('content')
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Donation Users</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="{{ url('admin/home') }}">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Donation Users</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  @include('common.notify')
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card bg-light">
          <div class="card-body">
            <div class="d-flex m-b-30 no-block">
              <h5 class="card-title m-b-0 align-self-center">View Donation Users</h5>
              <div class="ml-auto">
                <div class="dl">
                  <div class="col-3 align-self-center"> <a class="btn btn-primary addRecord" href="javascript:;"><i class="icon-Add"></i> Add Donation User</a> </div>
                </div>
              </div>
            </div>
            <div class="table-responsive">			
              <table class="table bg-white table-bordered nowrap display file_export">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Full Name</th>
					<th>Email Address</th>
					<th>Contact Number</th>
                    <th>Postal Code</th>
					<th>Joined On</th>
                    <th class="noExport">Actions</th>
                  </tr>
                </thead>
                <tbody>
                @foreach($donors as $index => $donor)
                <tr>
                  <td>{{ $index + 1 }}</td>
                  <td>{{ $donor->first_name.' '.$donor->last_name }}</td>
				  <td><a href="mailto:{{ $donor->email }}">{{ $donor->email }}</a></td>
                  <td>{{ $donor->contact }}</td>
				  <td>{{ $donor->postal_code }}</td>
				  <td>{{ date('d/m/Y',strtotime($donor->created_at)) }}</td>
                  <!--<td>@if($donor->status=='1') <a href="{{ route('admin.donor.uptStatus', ['id'=>$donor->id,'status'=>'0']) }}" class="label label-success">Active</a> @else <a href="{{ route('admin.donor.uptStatus', ['id'=>$donor->id,'status'=>'1']) }}" class="label label-danger">Inactive</a> @endif</td>-->
                  <td><form action="{{ route('admin.donor.destroy', $donor->id) }}" method="POST">
                      {{ csrf_field() }}
                      <input type="hidden" name="_method" value="DELETE">
                      <!--<a href="{{ route('admin.donor.show', $donor->id) }}" class="btn btn-primary btn-sm"><i class="fas fa-eye" title="View"></i></a>--> <!--<a href="{{ route('admin.donor.edit', $donor->id) }}" class="btn btn-info btn-sm"><i class="fa fa-edit"></i> Edit</a>-->
					  @if(Auth::guard('admin')->user()->utype=='Super')
					  <a href="javascript:;" class="btn btn-info btn-sm editRecord" data-id="{{ $donor->id }}"><i class="fa fa-edit"></i> Edit</a>
					  @else
					  @endif
					  
					  
                      <button onclick="return confirm('Are you sure?')" class="btn btn-danger btn-sm"><i class="fa fa-trash-alt"></i> Delete</button>
                    </form></td>
                </tr>
                @endforeach
                </tbody>
                
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection

@push('modals')
@include('admin.donor.partials.addDonorModal',['module'=>'donor'])
@endpush
