@extends('admin.includes.base')
@section('content')
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Donor Reports</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="{{ url('admin/home') }}">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Donor Reports</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  @include('common.notify')
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card bg-light">
          <div class="card-body">
            <div class="d-flex m-b-30 no-block">
              <h5 class="card-title m-b-0 align-self-center">View Donor Reports</h5>
              <div class="ml-auto">
                <div class="dl">
                  <div class="col-3 align-self-center"> </div>
                </div>
              </div>
            </div>
            <form method="get" action="{{ route('admin.report.donor') }}">
              <div class="row">
                <div class="col-md-4">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Donor<span class="asterrisk">*</span></label>
                    <div class="clearfix"></div>
                    <select class="form-control" id="select2-donor" name="donor" style="width:100%;" required>
                      <option value="">Select Donor</option>
                      
					  @if(!empty($donors))
					  @foreach($donors as $customer)
                    
                      <option value="{{ $customer->id }}" @if(Request::has('donor')) @if(Request::get('donor')==$customer->id) selected="selected" @endif @endif>{{ '#'.$customer->id.' - '.$customer->first_name.' '.$customer->last_name }}</option>
                      
                    
                    
					  @endforeach
					  @endif
                    
                  
                  
                    </select>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">From - To<span class="asterrisk">*</span></label>
                    <div class="clearfix"></div>
                    <div class='input-group mb-3'>
                      <input type='text' class="form-control daterange" name="daterange" required @if(Request::has('daterange')) value="{{ Request::get('daterange') }}" @endif autocomplete="off"/>
                      <div class="input-group-append"> <span class="input-group-text"> <span class="ti-calendar"></span> </span> </div>
                    </div>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">&nbsp;</label>
                    <div class='input-group mb-3'>
                      <button type="submit" class="btn btn-success"><i class="ti-filter"></i> Filter</button>
                    </div>
                  </div>
                </div>
              </div>
            </form>
            @if(Request::has('donor') && Request::has('daterange'))
			@if(!empty($reports))
            <div class="table-responsive">
              <table class="table bg-white table-bordered nowrap display file_export">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Receipt ID</th>
                    <th>Donor Name</th>
                    <th>Donor Contact</th>
                    <th>Amount</th>
                    <th>Payment Method</th>
                    <th>Payment Status</th>
                    <th>Collected By</th>
					<th>Batch Status</th>
					<th>Batch Closed By</th>
					<th>Batch Closed On</th>
                    <th>Donated On</th>
                  </tr>
                </thead>
                <tbody>
                
                @foreach($reports as $index => $receipt)
                <tr>
                  <td>{{ $index + 1 }}</td>
                  <td>{{ $receipt->receipt_no }}</td>
                  @if(!empty($receipt->donorInfo))
                  <td>{{ $receipt->donorInfo->first_name.' '.$receipt->donorInfo->last_name }}</td>
                  <td>{{ $receipt->donorInfo->contact }}</td>
                  @else
                  <td>-</td>
                  <td>-</td>
                  @endif
                  <td>$ {{ $receipt->amount }}</td>
                  <td>{{ $receipt->payment_mode }}</td>
                  <td>@if($receipt->payment_status=='Paid') <span class="label label-success">Paid
              </span>
              @else <span class="label label-danger">Not Paid
              </span>
              @endif</td>
                  <td>{{ $receipt->adminInfo->name }}</td>
				  <td>@if($receipt->batch_status=='Open') <span class="label label-success">Open
              </span>
              @else <span class="label label-danger">Closed
              </span>
              @endif</td>
			  		
					@if($receipt->batch_status=='Closed')
					<td>{{ $receipt->batchAdminInfo->name }}</td>
					<td>{{ date('d/m/Y',strtotime($receipt->batch_updated_on)) }}</td>
					@else
					<td>-</td>
					<td>-</td>
					@endif
                  <td>{{ date('d/m/Y',strtotime($receipt->created_at)) }}</td>
                </tr>
                @endforeach
                </tbody>
                
              </table>
            </div>
			@endif
            @endif </div>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection