@extends('admin.includes.base')
@section('content')
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Testimonials</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="dashboard">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Testimonials</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  @include('common.notify')
  <div class="container-fluid">
    <div class="row">
      <div class="col-12">
        <div class="card">
          <div class="card-body">
            <h4 class="card-title">Add Testimonial</h4>
          </div>
          <hr class="m-t-0">
		  <form class="form-horizontal r-separator" action="{{route('admin.testimonial.store')}}" method="POST" enctype="multipart/form-data" role="form">
		  {{csrf_field()}}
            <div class="card-body bg-light">
              <div class="row">
                <div class="col-12">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Name</label>
                    <input class="form-control" type="text" value="{{ old('name') }}" name="name" required id="title" placeholder="Name">
                  </div>
                </div>
				<div class="col-12">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Designation</label>
                    <input class="form-control" type="text" value="{{ old('designation') }}" name="designation" required id="title" placeholder="Designation">
                  </div>
                </div>
                <div class="col-12">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Description</label>
                    <textarea class="form-control" id="inputEmail3" rows="5" name="description">{{ old('description') }}</textarea>
                  </div>
                </div>
				<div class="col-12">
                  <div class="custom-file">
					<input type="file" class="custom-file-input" id="customFile" name="picture">
                    <label class="custom-file-label" for="customFile">Upload Picture</label>
                  </div>
                </div>
              </div>
            </div>
            <div class="card-body">
              <div class="form-group m-b-0 text-right">
                <button type="submit" class="btn btn-info waves-effect waves-light">Save</button>
				<a href="{{route('admin.testimonial.index')}}" class="btn btn-dark waves-effect waves-light deactive_button">Cancel</a>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection