@extends('admin.includes.base')
@section('content')
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Site Settings</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="{{ url('admin/home') }}">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Site Settings</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  @include('common.notify')
  <div class="container-fluid">
    <div class="row">
      <div class="col-12">
      <div class="card">
      <div class="card-body">
        <div class="d-flex m-b-30 no-block">
          <h5 class="card-title m-b-0 align-self-center">Site Settings</h5>
          <div class="ml-auto">
            <div class="dl">
              <div class="col-3 align-self-center">
              </div>
            </div>
          </div>
        </div>
      </div>
      <hr class="m-t-0">
      <form class="form-horizontal" action="{{route('admin.setting.update', $setting->id )}}" method="POST" enctype="multipart/form-data" role="form">
        {{csrf_field()}}
        <input type="hidden" name="_method" value="PATCH">
        <div class="card-body bg-light">
          <div class="row">
            <div class="col-12">
              <ul class="nav nav-pills m-t-30 m-b-30">
                <li class=" nav-item"> <a href="#navpills-1" class="nav-link active" data-toggle="tab" aria-expanded="false"><img src="{{ asset('assets/images/english.png') }}" width="20"/> English</a> </li>
                <li class="nav-item"> <a href="#navpills-2" class="nav-link" data-toggle="tab" aria-expanded="false"> <img src="{{ asset('assets/images/spanish.png') }}" width="20"/> Spanish</a> </li>
              </ul>
              <div class="tab-content br-n pn" style="border: 1px solid #222;padding: 20px;">
                <div id="navpills-1" class="tab-pane active">
                  <div class="row">
                    <div class="col-12">
                      <center>
                        <h4>English Content</h4>
                      </center>
                    </div>
					<div class="col-12">
                      <div class="form-group">
                        <label for="inputEmail3" class="control-label col-form-label">Logo</label>
                        <div class="">
				  <div class="showimg"> 
				  @if(isset($setting->logo_en)) 
				  <img id="testimonialbyicon" src="{{ url('storage/'.$setting->logo_en) }}" width="100" height="100" /> 
				  @else
				  <img id="testimonialbyicon" src="http://placehold.it/100x100" alt="your image" width="100" width="100" />
				  @endif
				   </div>
                    <input type="file" name="logo_en" onchange="readURL(this,'testimonialbyicon');">
                  </div>
                      </div>
                    </div>
                    <div class="col-12">
                      <div class="form-group">
                        <label for="inputEmail3" class="control-label col-form-label">Site Title</label>
                        <input class="form-control" type="text" value="{{ $setting->stitle_en }}" name="stitle_en" required id="email" placeholder="Site Title">
                      </div>
                    </div>
                    <div class="col-12">
                      <div class="form-group">
                        <label for="inputEmail3" class="control-label col-form-label">Meta Keywords</label>
                        <textarea class="form-control" name="metakey_en" cols="7" rows="3" data-sample="1" data-sample-short="">{{ $setting->metakey_en }}</textarea>
                      </div>
                    </div>
                    <div class="col-12">
                      <div class="form-group">
                        <label for="inputEmail3" class="control-label col-form-label">Meta Description</label>
                        <textarea class="form-control" name="metadesc_en" cols="7" rows="3" data-sample="1" data-sample-short="">{{ $setting->metadesc_en }}</textarea>
                      </div>
                    </div>
                    <div class="col-12">
                      <div class="form-group">
                        <label for="inputEmail3" class="control-label col-form-label">Address</label>
                        <textarea class="form-control" name="address_en" cols="7" rows="3" data-sample="1" data-sample-short="">{{ $setting->address_en }}</textarea>
                      </div>
                    </div>
                  </div>
                </div>
                <div id="navpills-2" class="tab-pane">
                  <div class="row">
                    <div class="col-12">
                      <center>
                        <h4>Spanish Content</h4>
                      </center>
                    </div>
					<div class="col-12">
                      <div class="form-group">
                        <label for="inputEmail3" class="control-label col-form-label">Logo</label>
                        <div class="">
				  <div class="showimg"> 
				  @if(isset($setting->logo_sp)) 
				  <img id="testimonialbyicon1" src="{{ url('storage/'.$setting->logo_sp) }}" width="100" height="100" /> 
				  @else
				  <img id="testimonialbyicon1" src="http://placehold.it/100x100" alt="your image" width="100" width="100" />
				  @endif
				   </div>
                    <input type="file" name="logo_sp" onchange="readURL(this,'testimonialbyicon1');">
                  </div>
                      </div>
                    </div>
                    <div class="col-12">
                      <div class="form-group">
                        <label for="inputEmail3" class="control-label col-form-label">Site Title</label>
                        <input class="form-control" type="text" value="{{ $setting->stitle_sp }}" name="stitle_sp" required id="email" placeholder="Site Title">
                      </div>
                    </div>
                    <div class="col-12">
                      <div class="form-group">
                        <label for="inputEmail3" class="control-label col-form-label">Meta Keywords</label>
                        <textarea class="form-control" name="metakey_sp" cols="7" rows="3" data-sample="1" data-sample-short="">{{ $setting->metakey_sp }}</textarea>
                      </div>
                    </div>
                    <div class="col-12">
                      <div class="form-group">
                        <label for="inputEmail3" class="control-label col-form-label">Meta Description</label>
                        <textarea class="form-control" name="metadesc_sp" cols="7" rows="3" data-sample="1" data-sample-short="">{{ $setting->metadesc_sp }}</textarea>
                      </div>
                    </div>
                    <div class="col-12">
                      <div class="form-group">
                        <label for="inputEmail3" class="control-label col-form-label">Address</label>
                        <textarea class="form-control" name="address_sp" cols="7" rows="3" data-sample="1" data-sample-short="">{{ $setting->address_sp }}</textarea>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-12">
              <div class="form-group">
                <label for="inputEmail3" class="control-label col-form-label">Contact</label>
                <input class="form-control" type="text" value="{{ $setting->contact }}" name="contact" required id="contact" placeholder="Contact">
              </div>
            </div>
            <!--<div class="col-12">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Admin Email</label>
                    <input class="form-control" type="text" value="{{ $setting->
            adminemail }}" name="adminemail" required id="email" placeholder="Admin Email"> </div>
        </div>
        -->
        <div class="col-12">
          <div class="form-group">
            <label for="inputEmail3" class="control-label col-form-label">Email Id</label>
            <input class="form-control" type="text" value="{{ $setting->email }}" name="email" required id="email" placeholder="Email Id">
          </div>
        </div>
        <div class="col-12">
          <div class="form-group">
            <label for="inputEmail3" class="control-label col-form-label">Website</label>
            <input class="form-control" type="text" value="{{ $setting->website }}" name="website" required id="email" placeholder="Website">
          </div>
        </div>
        <h2>Social Media</h2>
        <div class="col-12">
          <div class="form-group">
            <label for="inputEmail3" class="control-label col-form-label">Facebook</label>
            <input class="form-control" type="text" value="{{ $setting->facebook }}" name="facebook" required id="email" placeholder="Facebook">
          </div>
        </div>
        <div class="col-12">
          <div class="form-group">
            <label for="inputEmail3" class="control-label col-form-label">Twitter</label>
            <input class="form-control" type="text" value="{{ $setting->twitter }}" name="twitter" required id="email" placeholder="Twitter">
          </div>
        </div>
        <div class="col-12">
          <div class="form-group">
            <label for="inputEmail3" class="control-label col-form-label">Linkedin</label>
            <input class="form-control" type="text" value="{{ $setting->linkedin }}" name="linkedin" required id="email" placeholder="Linkedin">
          </div>
        </div>
        <div class="col-12">
          <div class="form-group">
            <label for="inputEmail3" class="control-label col-form-label">Google Plus</label>
            <input class="form-control" type="text" value="{{ $setting->gplus }}" name="gplus" required id="email" placeholder="Google Plus">
          </div>
        </div>
        </div>
        </div>
        <div class="card-body">
          <div class="form-group m-b-0 text-right">
            <button type="submit" class="btn btn-info waves-effect waves-light">Save</button>
            <a href="{{route('admin.setting.index')}}" class="btn btn-dark waves-effect waves-light deactive_button">Cancel</a> </div>
        </div>
      </form>
    </div>
  </div>
</div>
</div>
</div>
</div>
@endsection