<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Accounting</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="<?php echo e(url('admin/home')); ?>">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Accounting</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php echo $__env->make('common.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card bg-light">
          <div class="card-body">
            <form method="get" action="<?php echo e(route('admin.accounting.filter')); ?>">
              <div class="row">
			  <div class="col-md-3">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Payment Method</label>
                    <div class="clearfix"></div>
                    <select class="form-control" name="payment_mode" style="width:100%;">
                      <option value="">Select Payment Method</option>
                      <option value="Cash" <?php if(Request::has('payment_mode') && Request::get('payment_mode')=="Cash"): ?> selected="selected" <?php endif; ?>>Cash</option>
              <option value="Cheque" <?php if(Request::has('payment_mode') && Request::get('payment_mode')=="Cheque"): ?> selected="selected" <?php endif; ?>>Cheque</option>
              <!--<option value="Pledge" <?php if(old('payment_mode')=='Pledge'): ?> selected="selected" <?php endif; ?>>Pledge</option>
                    <option value="Card" <?php if(old('payment_mode')=='Card'): ?> selected="selected" <?php endif; ?>>Card</option>-->
              <option value="Online" <?php if(Request::has('payment_mode') && Request::get('payment_mode')=="Online"): ?> selected="selected" <?php endif; ?>>Online</option>
              <option value="E-Transfer" <?php if(Request::has('payment_mode') && Request::get('payment_mode')=="E-Transfer"): ?> selected="selected" <?php endif; ?>>E-Transfer</option>
			  <option value="Pledge" <?php if(Request::has('payment_mode') && Request::get('payment_mode')=="Pledge"): ?> selected="selected" <?php endif; ?>>Pledge</option>
                    </select>
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">Batch Status</label>
                    <div class="clearfix"></div>
                    <select class="form-control" name="batch_status" style="width:100%;">
                      <option value="">Select Batch Status</option>
                      <option value="Open" <?php if(Request::has('batch_status') && Request::get('batch_status')=="Open"): ?> selected="selected" <?php endif; ?>>Open</option>
					  <option value="Closed" <?php if(Request::has('batch_status') && Request::get('batch_status')=="Closed"): ?> selected="selected" <?php endif; ?>>Closed</option>
                    </select>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">From - To<span class="asterrisk">*</span></label>
                    <div class="clearfix"></div>
                    <div class='input-group mb-3'>
                      <input type='text' class="form-control daterange" name="daterange" required <?php if(Request::has('daterange')): ?> value="<?php echo e(Request::get('daterange')); ?>" <?php endif; ?> autocomplete="off"/>
                      <div class="input-group-append"> <span class="input-group-text"> <span class="ti-calendar"></span> </span> </div>
                    </div>
                  </div>
                </div>
                <div class="col-md-2">
                  <div class="form-group">
                    <label for="inputEmail3" class="control-label col-form-label">&nbsp;</label>
                    <div class='input-group mb-3'>
                      <button type="submit" class="btn btn-success"><i class="ti-filter"></i> Filter</button>
                    </div>
                  </div>
                </div>
              </div>
            </form>
            <?php if(Request::has('daterange')): ?>
            <?php if(!empty($reports)): ?>
            <div class="table-responsive">
              <table class="table bg-white table-bordered nowrap display file_export_report ">
                <thead>
                  <tr>
                    <th>Receipt ID</th>
                    <th>Donor Name</th>
                    <th>Donor Contact</th>
                    <th>Amount</th>
                    <th>Payment Method</th>
                    <th>Payment Status</th>
                    <th>Collected By</th>
                    <th>Donated On</th>
                  </tr>
                </thead>
                <tbody>
                <?php $total = '0.0'; ?>
                <?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $receipt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td><?php echo e($receipt->receipt_no); ?></td>
                  <?php if(!empty($receipt->donorInfo)): ?>
                  <td><?php echo e($receipt->donorInfo->first_name.' '.$receipt->donorInfo->last_name); ?></td>
                  <td><?php echo e($receipt->donorInfo->contact); ?></td>
                  <?php else: ?>
                  <td>-</td>
                  <td>-</td>
                  <?php endif; ?>
                  <td>$ <?php echo e($receipt->amount); ?></td>
                  <td><?php echo e($receipt->payment_mode); ?></td>
                  <td><?php if($receipt->payment_status=='Paid'): ?> <span class="label label-success">Paid
                    </span>
                    <?php else: ?> <span class="label label-danger">Not Paid
                    </span>
                    <?php endif; ?></td>
                  <td><?php echo e($receipt->adminInfo->name); ?></td>
                  <td><?php echo e(date('d/m/Y',strtotime($receipt->created_at))); ?></td>
                </tr>
				<?php $total += $receipt->amount; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				<tr>
				<td></td>
				<td></td>
                  <td align="right"><strong>Total</strong></td>
                  <td align="left"><strong>$ <?php echo e($total); ?></strong></td>
                  <td colspan=""></td>
				  <td colspan=""></td>
				  <td colspan=""></td>
				  <td colspan=""></td>
                </tr>
                </tbody>
                
              </table>
            </div>
            <?php endif; ?>
            <?php endif; ?> </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<!--<script>
$(document).ready(function()
{

$("#checkAll").click(function () {
     $('input:checkbox').not(this).prop('checked', this.checked);
	 
	 if()
	 
 });
 });
</script>-->


<script type="text/javascript">
function calculateAmount(){
var amount = parseFloat('0.0');
$('.checkbox').each(function(){
      if ($(this).is(':checked')) {
	  var pamount = $(this).attr('data-amount');
	  amount += parseFloat(pamount);
	  }
});
$('#total').val(amount.toFixed(2));
}
$(document).ready(function(){
    $('#checkAll').on('click',function(){
        if(this.checked){
            $('.checkbox').each(function(){
                this.checked = true;
				$('.updateBatchDiv').css('display','block');
            });
        }else{
             $('.checkbox').each(function(){
                this.checked = false;
				$('.updateBatchDiv').css('display','none');
            });
        }
		calculateAmount();
    });
    
    $('.checkbox').on('click',function(){
        if($('.checkbox:checked').length == $('.checkbox').length){
            $('#checkAll').prop('checked',true);
			
        }else{
            $('#checkAll').prop('checked',false);
			$('.updateBatchDiv').css('display','none');
        }
		if($('.checkbox:checked').length>0)
		{
		$('.updateBatchDiv').css('display','block');
		}
		else
		{
		$('.updateBatchDiv').css('display','none');
		}
		calculateAmount();
    });
});
</script>

<script>

         $(document).ready(function(){
		 
            $('#ajaxSubmit').click(function(e){
			var btn = $(this);
			var old_html = btn.html();
			btn.html('Please wait...');
            btn.attr('disabled', true);
			
			$('#form span.help-block').text(' ');
			
			var myObject = new Object();
			var other_data = $('#form').serializeArray();
			$.each(other_data,function(key,input){
				myObject[input.name] = input.value;
			});
			
			myObject['check_list'] = $.map($('.checkbox:checked'), function(c){return c.value; }).join(',');
			
			//alert(JSON.stringify(myObject));
			
			
               e.preventDefault();
               $.ajaxSetup({
                  headers: {
                      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                  }
              });
			 
			  
			  var url = "<?php echo e(route('admin.accounting.store')); ?>";
			  var method = 'post';
			  
			  //alert(url+" "+method);
               jQuery.ajax({
                  url: url,
                  method: method,   				  
				  data: myObject,
                  success: function(result){
				  //alert(JSON.stringify(result));
				  //alert('title='+result.responseJSON.errors.title);
                  	if(result.errors)
                  	{
                  		//jQuery('.alert-danger').html('');

                  		jQuery.each(result.errors, function(key, value){
							//alert(key);
                  			//jQuery('.alert-danger').show();
                  			//jQuery('.alert-danger').append('<li>'+value+'</li>');
							jQuery('#'+key+'Error').text(value);
                  		});
                  	}
                  	else
                  	{
                  		//jQuery('.alert-success').show();
						//jQuery('.alert-success').text(result.message);
						toastr.success(result.message);
						
						// redirect to google after 5 seconds
						window.setTimeout(function() {
							window.location.href = "<?php echo e(url('admin/accounting/history')); ?>";
						}, 2000);
						
                  		
                  	}
					btn.html(old_html);
                    btn.attr('disabled', false);
                  },
				  error: function(err){
				  	alert(JSON.stringify(err));
				  }  
				  });
               });			   
			   
            });
      </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.includes.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/donationgnfb/public_html/resources/views/admin/accounting/filter.blade.php ENDPATH**/ ?>