<?php $__env->startPush('styles'); ?>
<style>
.table td
{
padding: 15px 10px!important;
}
.cash-table tr th:first-child input{
width:50px;
}
.cash-table tr td:nth-child(2) input{
width:80px;
}
.cash-table tr td:nth-child(3) input{
width:140px;
}
.table-responsive
{
	display: block;
    height: 432px;
    overflow-y: scroll;
}
</style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Deposit Slip</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="<?php echo e(url('admin/home')); ?>">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Deposit Slip</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php echo $__env->make('common.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="container-fluid">
    <div class="row">
      <div class="col-sm-12 col-md-12">
        <div class="card">
          <div class="card-body padd-10">
            <h4 class="card-title">Deposit Slip</h4>
          </div>
          <hr class="m-t-0">
          <form class="form-horizontal r-separator" action="<?php echo e(route('admin.accounting.deposit.slip.store')); ?>" method="POST" enctype="multipart/form-data" role="form">
            <?php echo e(csrf_field()); ?>

            <input type="hidden" name="deposit_id" value="<?php echo e((!empty($deposit)) ? $deposit->id : ''); ?>"/>
            <input type="hidden" name="accounting_id" value="<?php echo e($id); ?>"/>
            <div class="card-body bg-light">
              <div class="row">
                <div class="col-12">
                  <div class="col-6">
                    <div class="form-group">
                      <label for="inputEmail3" class="control-label col-form-label">Select Bank<span class="asterrisk">*</span></label>
                      <select class="form-control" name="bank_type" id="bank_type">
                        <option value="">--Select--</option>
                        <option value="Canada Trust" data-account="92740 004 0024 5259957" <?php if(!empty($deposit) && $deposit->bank_type=='Canada Trust'): ?> selected="selected" <?php elseif(old('bank_type')=='Canada Trust'): ?> selected="selected" <?php endif; ?>>Canada Trust</option>
                        <option value="Khalsa Credit Union" data-account="58220" <?php if(!empty($deposit) && $deposit->bank_type=='Khalsa Credit Union'): ?> selected="selected" <?php elseif(old('bank_type')=='Khalsa Credit Union'): ?> selected="selected" <?php endif; ?>>Khalsa Credit Union</option>
                      </select>
                      <?php if($errors->has('bank_type')): ?> <span class="help-block"> <strong><?php echo e($errors->first('bank_type')); ?></strong> </span> <?php endif; ?> </div>
                  </div>
                  <div class="col-6" style="display:none;">
                    <div class="form-group">
                      <label for="inputEmail3" class="control-label col-form-label">Account Number<span class="asterrisk">*</span></label>
                      <!--<input class="form-control amount" type="text" value="<?php echo e((!empty($deposit)) ? $deposit->
                      account_number : old('account_number')); ?>" name="account_number" id="account_number" placeholder="Account Number" autocomplete="off">-->
                      <input class="form-control" type="text" value="92740 004 0024 5259957" name="account_number" id="account_number" placeholder="Account Number" autocomplete="off">
                      <?php if($errors->has('account_number')): ?> <span class="help-block"> <strong><?php echo e($errors->first('account_number')); ?></strong> </span> <?php endif; ?> </div>
                  </div>
                  <div class="col-6"></div>
                  <div class="col-12">
                    <div class="row">
                      <div class="col-6">
                        <h4>CASH COUNT</h4>
                        <?php
                        if(!empty($deposit))
                        {
                        $cash_type = explode(',',$deposit->cash_type);
                        $cash_amount = explode(',',$deposit->cash_amount);
                        $cash_count = explode(',',$deposit->cash_count);
                        }
                        else
                        {
                        $cash_type = '';
                        $cash_amount = '';
                        $cash_count = '';
                        }				  
                        ?>
                        <table class="table table-bordered cash-table">
                          <tr>
                            <th width="100"></th>
                            <th width="100">Count</th>
                            <th width="">Total</th>
                          </tr>
                          <tr>
                            <th><input type="text" class="cash_type" name="cash_type[0]" value="1.00" readonly="readonly" /></th>
                            <td><input type="text" class="amount toCount" name="cash_amount[0]" value="<?php echo e((!empty($cash_amount)) ? $cash_amount[0] : old('cash_amount.0')); ?>" autocomplete="off" /></td>
                            <td><input type="text" class="amount toAdd" name="cash_count[0]" value="<?php echo e((!empty($cash_count)) ? $cash_count[0] : old('cash_count.0')); ?>" autocomplete="off" /></td>
                          </tr>
                          <tr>
                            <th><input type="text" class="cash_type" name="cash_type[1]" value="2.00" readonly="readonly" /></th>
                            <td><input type="text" class="amount toCount" name="cash_amount[1]" value="<?php echo e((!empty($cash_amount)) ? $cash_amount[1] : old('cash_amount.1')); ?>" autocomplete="off" /></td>
                            <td><input type="text" class="amount toAdd" name="cash_count[1]" value="<?php echo e((!empty($cash_count)) ? $cash_count[1] : old('cash_count.1')); ?>" autocomplete="off" /></td>
                          </tr>
                          <tr>
                            <th><input type="text" class="cash_type" name="cash_type[2]" value="5.00" readonly="readonly" /></th>
                            <td><input type="text" class="amount toCount" name="cash_amount[2]" value="<?php echo e((!empty($cash_amount)) ? $cash_amount[2] : old('cash_amount.2')); ?>" autocomplete="off" /></td>
                            <td><input type="text" class="amount toAdd" name="cash_count[2]" value="<?php echo e((!empty($cash_count)) ? $cash_count[2] : old('cash_count.2')); ?>" autocomplete="off" /></td>
                          </tr>
                          <tr>
                            <th><input type="text" class="cash_type" name="cash_type[3]" value="10.00" readonly="readonly" /></th>
                            <td><input type="text" class="amount toCount" name="cash_amount[3]" value="<?php echo e((!empty($cash_amount)) ? $cash_amount[3] : old('cash_amount.3')); ?>" autocomplete="off" /></td>
                            <td><input type="text" class="amount toAdd" name="cash_count[3]" value="<?php echo e((!empty($cash_count)) ? $cash_count[3] : old('cash_count.3')); ?>" autocomplete="off" /></td>
                          </tr>
                          <tr>
                            <th><input type="text" class="cash_type" name="cash_type[4]" value="20.00" readonly="readonly" /></th>
                            <td><input type="text" class="amount toCount" name="cash_amount[4]" value="<?php echo e((!empty($cash_amount)) ? $cash_amount[4] : old('cash_amount.4')); ?>" autocomplete="off" /></td>
                            <td><input type="text" class="amount toAdd" name="cash_count[4]" value="<?php echo e((!empty($cash_count)) ? $cash_count[4] : old('cash_count.4')); ?>" autocomplete="off" /></td>
                          </tr>
                          <tr>
                            <th><input type="text" class="cash_type" name="cash_type[5]" value="50.00" readonly="readonly" /></th>
                            <td><input type="text" class="amount toCount" name="cash_amount[5]" value="<?php echo e((!empty($cash_amount)) ? $cash_amount[5] : old('cash_amount.5')); ?>" autocomplete="off" /></td>
                            <td><input type="text" class="amount toAdd" name="cash_count[5]" value="<?php echo e((!empty($cash_count)) ? $cash_count[5] : old('cash_count.5')); ?>" autocomplete="off" /></td>
                          </tr>
                          <tr>
                            <th><input type="text" class="cash_type" name="cash_type[6]" value="100.00" readonly="readonly" /></th>
                            <td><input type="text" class="amount toCount" name="cash_amount[6]" value="<?php echo e((!empty($cash_amount)) ? $cash_amount[6] : old('cash_amount.6')); ?>" autocomplete="off" /></td>
                            <td><input type="text" class="amount toAdd" name="cash_count[6]" value="<?php echo e((!empty($cash_count)) ? $cash_count[6] : old('cash_count.6')); ?>" autocomplete="off" /></td>
                          </tr>
                        </table>
                      </div>
                      <div class="col-6">
                        <h4>CHEQUE</h4>
                        <?php
                        if(!empty($deposit))
                        {
                        $cash_type = explode(',',$deposit->cash_type);
                        $cash_amount = explode(',',$deposit->cash_amount);
                        $cash_count = explode(',',$deposit->cash_count);
                        }
                        else
                        {
                        $cash_type = '';
                        $cash_amount = '';
                        $cash_count = '';
                        }				  
                        ?>
                        <div class="table-responsive">
                          <table class="table table-bordered cheque-table">
                            <thead>
                              <tr>
                                <th>Cheque Details</th>
                                <th>Amount</th>
                              </tr>
                            </thead>
                            <tbody>
                            
                            <?php for($i=0; $i<14; $i++): ?>
                            <tr>
                              <td><input type="text" class="" name="cheque_nos[]" value="<?php echo e((!empty($cheque_array[$i])) ? $cheque_array[$i]['cheque_details'] : ''); ?>" autocomplete="off" /></td>
                              <td><input type="text" class="amount camount" name="cheque_amounts[]" value="<?php echo e((!empty($cheque_array[$i])) ? $cheque_array[$i]['cheque_amount'] : ''); ?>" autocomplete="off" /></td>
                            </tr>
                            <?php endfor; ?>
                            </tbody>
                            
                          </table>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-12">
                    <h4>DEPOSIT</h4>
                    <div class="row">
                      <div class="col-6">
                        <div class="form-group">
                          <label for="inputEmail3" class="control-label col-form-label">Cash Subtotal</label>
                          <input class="form-control amount" type="text" value="<?php echo e((!empty($deposit)) ? $deposit->cash_subtotal : $cash_total); ?>" name="cash_subtotal" id="cash_subtotal" placeholder="Cash Subtotal" autocomplete="off">
                          <?php if($errors->has('cash_subtotal')): ?> <span class="help-block"> <strong><?php echo e($errors->first('cash_subtotal')); ?></strong> </span> <?php endif; ?> </div>
                      </div>
                      <div class="col-6">
                        <div class="form-group">
                          <label for="inputEmail3" class="control-label col-form-label">Cheque Subtotal</label>
                          <input class="form-control amount" type="text" value="<?php echo e((!empty($deposit)) ? $deposit->cheque_subtotal : $cheque_total); ?>" name="cheque_subtotal" id="cheque_subtotal" placeholder="Cheque Subtotal" autocomplete="off">
                          <?php if($errors->has('cheque_subtotal')): ?> <span class="help-block"> <strong><?php echo e($errors->first('cheque_subtotal')); ?></strong> </span> <?php endif; ?> </div>
                      </div>
                      <div class="col-6">
                        <div class="form-group">
                          <label for="inputEmail3" class="control-label col-form-label">Deposit Total<span class="asterrisk">*</span></label>
                          <input class="form-control amount" type="text" value="<?php echo e((!empty($deposit)) ? $deposit->deposit_total : old('deposit_total')); ?>" name="deposit_total" id="deposit_total" placeholder="Deposit Total" autocomplete="off">
                          <?php if($errors->has('deposit_total')): ?> <span class="help-block"> <strong><?php echo e($errors->first('deposit_total')); ?></strong> </span> <?php endif; ?> </div>
                      </div>
                      <div class="col-6">
                        <div class="form-group">
                          <label for="inputEmail3" class="control-label col-form-label">Notes</label>
                          <textarea class="form-control" type="text" name="notes" id="notes" placeholder="Notes" autocomplete="off"><?php echo e((!empty($deposit)) ? $deposit->notes : old('notes')); ?></textarea>
                          <?php if($errors->has('notes')): ?> <span class="help-block"> <strong><?php echo e($errors->first('notes')); ?></strong> </span> <?php endif; ?> </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="card-body">
              <div class="form-group m-b-0 text-right">
                <button type="submit" class="btn btn-info waves-effect waves-light">Next</button>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?> 

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function()
{
$('#bank_type').on('change',function()
{
var val = $('#bank_type').find(':selected').attr('data-account');
//alert('val='+val);
$('#account_number').val(val);
});

$(".amount").on("keyup", function(){
    var valid = /^\d{0,15}(\.\d{0,2})?$/.test(this.value),
        val = this.value;
    
    if(!valid){
        console.log("Invalid input!");
        this.value = val.substring(0, val.length - 1);
    }
});


$('.toCount').on('change', function() {
  //var total = parseFloat('0.0');

  $('.toCount').each(function () {
  	var toCount = $(this).val();
	
	var value = $(this).closest('tr').find('.cash_type').val();
	
	var calc = toCount*value;
	
	//alert('value='+value);
	$(this).closest('tr').find('.toAdd').val(calc);
	
	
	
	
    //total += parseFloat($(this).val()) || 0;
  });
  
  
  
  var total = parseFloat('0.0');

  $('.toAdd').each(function () {
    total += parseFloat($(this).val()) || 0;
  });
	//alert(total);
	var tt = total.toFixed(2);
  $('#cash_subtotal').val(tt);
  
  totall();
  
	//alert(total);
  //$('#cash_subtotal').val(total.toFixed(2));
});

/*$('.toAdd').on('change', function() {
  var total = parseFloat('0.0');

  $('.toAdd').each(function () {
    total += parseFloat($(this).val()) || 0;
  });
	//alert(total);
  $('#cash_subtotal').val(total.toFixed(2));
});*/


$('.camount').on('change', function() {
  var total = parseFloat('0.0');

  $('.camount').each(function () {
    total += parseFloat($(this).val()) || 0;
  });
	//alert(total);
  $('#cheque_subtotal').val(total.toFixed(2));
  totall();
});

});

function totall()
{
	var cash_subtotal = parseFloat($('#cash_subtotal').val()) || 0;
  var cheque_subtotal = parseFloat($('#cheque_subtotal').val()) || 0;
  
  var sum = cash_subtotal+cheque_subtotal;
  
  $('#deposit_total').val(sum.toFixed(2));
  
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.includes.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/donationgnfb/public_html/resources/views/admin/accounting/deposit-slip.blade.php ENDPATH**/ ?>