<?php $__env->startPush('styles'); ?>
<style>
.modal-content .card-body {
    padding: 10px 10px 0px;
}
</style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Receipts</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="<?php echo e(url('admin/home')); ?>">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Receipts</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php echo $__env->make('common.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card bg-light">
          <div class="card-body">
            <div class="d-flex m-b-30 no-block">
              <h5 class="card-title m-b-0 align-self-center">View Receipts</h5>
              <div class="ml-auto">
                <div class="dl">
                  <div class="col-3 align-self-center"> <a class="btn btn-primary" href="<?php echo e(route('admin.receipt.create')); ?>">New Receipt</a> </div>
                </div>
              </div>
            </div>
            <div class="table-responsive">
              <table class="table bg-white table-bordered nowrap display file_export">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Receipt ID</th>
                    <th>Donor Name</th>
                    <th>Donor Contact</th>
                    <th>Amount</th>
                    <th>Payment Method</th>
                    <th>Payment Status</th>
                    <th>Collected By</th>
					<th>Batch Status</th>
                    <th>Donated On</th>
                    <th class="noExport">Actions</th>
                  </tr>
                </thead>
                <tbody>
                
                <?php $__currentLoopData = $receipts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $receipt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td><?php echo e($index + 1); ?></td>
                  <td><?php echo e($receipt->receipt_no); ?></td>
                  <?php if(!empty($receipt->donorInfo)): ?>
                  <td><?php echo e($receipt->donorInfo->first_name.' '.$receipt->donorInfo->last_name); ?></td>
                  <td><?php echo e($receipt->donorInfo->contact); ?></td>
                  <?php else: ?>
                  <td>-</td>
                  <td>-</td>
                  <?php endif; ?>
                  <td>$ <?php echo e($receipt->amount); ?></td>
                  <td><?php echo e($receipt->payment_mode); ?></td>
                  <td><?php if($receipt->payment_status=='Paid'): ?> <span class="label label-success">Paid
              </span>
              <?php else: ?> <span class="label label-danger">Not Paid
              </span>
              <?php endif; ?></td>
                  <td><?php echo e($receipt->adminInfo->name); ?></td>
				  
				  <td><?php if($receipt->batch_status=='Open'): ?> <span class="label label-success">Open
              </span>
              <?php else: ?> <span class="label label-danger">Closed
              </span>
              <?php endif; ?></td>
				  
                  <td><?php echo e(date('d/m/Y',strtotime($receipt->created_at))); ?></td>
                  <td>
				  
				  <?php if(Auth::guard('admin')->user()->utype=='Super' || Auth::guard('admin')->user()->utype=='Admin'): ?>
				  
				  <a href="<?php echo e(route('admin.receipt.edit', $receipt->id)); ?>" class="btn btn-warning btn-sm"><i class="fa fa-edit"></i></a>
				  <?php endif; ?>
				  
				  <?php if($receipt->payment_mode=='Pledge'): ?>
				  <a href="javascript:;" class="btn btn-success btn-sm noReceipt"><i class="fa fa-print"></i></a>
				  <?php else: ?>
				  <a href="<?php echo e(route('admin.receipt.print', $receipt->id)); ?>" class="btn btn-success btn-sm"><i class="fa fa-print"></i></a>
				  <?php endif; ?>
				  <a href="javascript:;" class="btn btn-info btn-sm receipt-details" data-id="<?php echo e($receipt->id); ?>"><i class="fa fa-eye"></i></a></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel1">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title" id="exampleModalLabel1">Donation Details</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      </div>
      <div class="modal-body load-receipt-data"> </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>

function loadReceiptDetails(receipt_id)
{
	$(".load-receipt-data").html('<img src="<?php echo e(asset('admin_assets/images/loader.gif')); ?>" width="100" height="100" class="image-center"/>');
	var data = {'_token': "<?php echo csrf_token() ?>", 'receipt_id': receipt_id};
	//alert(JSON.stringify(data));
			$.ajax({
               type: 'POST',
               url: '<?php echo e(url("ajax/receipt/loadReceiptData")); ?>',
               data: data,
               success:function(data){
                  $(".load-receipt-data").html(data);
				  $('#exampleModal').modal('show');
				    //alert(JSON.stringify(data));
               },
			   error: function(err)
			   {
			   		//alert(JSON.stringify(err));
			   }
            });	
}

function markPaid(receipt_id)
{
	$(".load-receipt-data").html('<img src="<?php echo e(asset('admin_assets/images/loader.gif')); ?>" width="100" height="100" class="image-center"/>');
	var data = {'_token': "<?php echo csrf_token() ?>", 'receipt_id': receipt_id};
	//alert(JSON.stringify(data));
			$.ajax({
               type: 'POST',
               url: '<?php echo e(url("ajax/receipt/markPaidReceipt")); ?>',
               data: data,
               success:function(data){
                  $(".load-receipt-data").html(data);
				  $('#exampleModal').modal('show');
				    //alert(JSON.stringify(data));
               },
			   error: function(err)
			   {
			   		//alert(JSON.stringify(err));
			   }
            });	
}


$(document).ready(function() {
$(document).on('click','.receipt-details',function() {
	var receipt_id = $(this).attr('data-id');
	//alert('customer='+receipt_id);
	loadReceiptDetails(receipt_id);
});

$(document).on('click','.mark-paid',function() {
	var receipt_id = $(this).attr('data-id');
	//alert('customer='+workorder_id);
	markPaid(receipt_id);
});

$(document).on('click','.noReceipt',function()
{
alert('Unable to generate receipt now, will do so upon receipt of payment.');
});
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.includes.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/donationgnfb/public_html/resources/views/admin/receipt/index.blade.php ENDPATH**/ ?>