<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
  <!-- ============================================================== -->
  <!-- Bread crumb and right sidebar toggle -->
  <!-- ============================================================== -->
  <div class="page-breadcrumb">
    <div class="row">
      <div class="col-5 align-self-center">
        <h4 class="page-title">Receipts</h4>
        <div class="d-flex align-items-center"> </div>
      </div>
      <div class="col-7 align-self-center">
        <div class="d-flex no-block justify-content-end align-items-center">
          <div class="d-flex no-block justify-content-end align-items-center">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"> <a href="<?php echo e(url('admin/home')); ?>">Home</a> </li>
                <li class="breadcrumb-item active" aria-current="page">Receipts</li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php echo $__env->make('common.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="container-fluid">
    <div class="row">
    <div class="col-sm-12 col-md-9">
    <div class="card">
    <div class="card-body padd-10">
      <h4 class="card-title">Update Receipt</h4>
    </div>
    <hr class="m-t-0">
    <form class="form-horizontal r-separator" action="<?php echo e(route('admin.receipt.update', $receipt->id)); ?>" method="POST" enctype="multipart/form-data" role="form">
      <?php echo e(csrf_field()); ?>

      <input type="hidden" name="_method" value="PATCH">
      <div class="card-body bg-light">
        <h4>Donor Information</h4>
        <div class="row">
          <div class="col-sm-12 col-md-8">
            <div class="row">
              <div class="col-6">
                <div class="form-group">
                  <label for="inputEmail3" class="control-label col-form-label">First Name<span class="asterrisk">*</span></label>
                  <input type="text" class="form-control" id="inputEmail3" name="first_name" value="<?php echo e(old('first_name') ?? $donorInfo->first_name); ?>" autocomplete="off">
                  <?php if($errors->has('first_name')): ?> <span class="help-block"> <strong><?php echo e($errors->first('first_name')); ?></strong> </span> <?php endif; ?> </div>
              </div>
              <div class="col-6">
                <div class="form-group">
                  <label for="inputEmail3" class="control-label col-form-label">Last Name<span class="asterrisk">*</span></label>
                  <input type="text" class="form-control" id="inputEmail3" name="last_name" value="<?php echo e(old('last_name') ?? $donorInfo->last_name); ?>" autocomplete="off">
                  <?php if($errors->has('last_name')): ?> <span class="help-block"> <strong><?php echo e($errors->first('last_name')); ?></strong> </span> <?php endif; ?> </div>
              </div>
            </div>
          </div>
          <div class="col-sm-12 col-md-4">
            <div class="form-group">
              <label for="inputEmail3" class="control-label col-form-label">Email Address<span class="asterrisk">*</span></label>
              <input type="email" class="form-control" id="inputEmail3" name="email" value="<?php echo e(old('email') ?? $donorInfo->email); ?>" autocomplete="off">
              <?php if($errors->has('email')): ?> <span class="help-block"> <strong><?php echo e($errors->first('email')); ?></strong> </span> <?php endif; ?> </div>
          </div>
          <div class="col-sm-12 col-md-6">
            <div class="form-group">
              <label for="inputEmail3" class="control-label col-form-label">Contact Number<span class="asterrisk">*</span></label>
              <div class="row">
                <div class="col-4">
                  <select class="form-control" name="contact_type">
                    <option value="Cell" <?php if($donorInfo->contact_type=='Cell'): ?> selected="selected" <?php endif; ?>>Cell</option>
                    <option value="Home" <?php if($donorInfo->contact_type=='Home'): ?> selected="selected" <?php endif; ?>>Home</option>
                    <option value="Office" <?php if($donorInfo->contact_type=='Office'): ?> selected="selected" <?php endif; ?>>Office</option>
                  </select>
                  <?php if($errors->has('contact_type')): ?> <span class="help-block"> <strong><?php echo e($errors->first('contact_type')); ?></strong> </span> <?php endif; ?> </div>
                <div class="phone-div col-8">
                  <input type="hidden" name="country_code" class="country_code" value="<?php echo e(old('country_code') ?? $donorInfo->country_code); ?>"/>
                  <input type="text" class="form-control phone" id="phone" name="contact" value="<?php echo e(old('contact')  ?? $donorInfo->contact); ?>" autocomplete="off">
                  <?php if($errors->has('contact')): ?> <span class="help-block"> <strong><?php echo e($errors->first('contact')); ?></strong> </span> <?php endif; ?> </div>
              </div>
            </div>
          </div>
          <div class="col-sm-12 col-md-6">
            <div class="form-group">
              <label for="inputEmail3" class="control-label col-form-label">Alternate Contact Number</label>
              <div class="row">
                <div class="col-4">
                  <select class="form-control" name="alternate_contact_type">
                    <option value="Home" <?php if($donorInfo->alternate_contact_type=='Home'): ?> selected="selected" <?php endif; ?>>Home</option>
                    <option value="Cell" <?php if($donorInfo->alternate_contact_type=='Cell'): ?> selected="selected" <?php endif; ?>>Cell</option>
                    <option value="Office" <?php if($donorInfo->alternate_contact_type=='Office'): ?> selected="selected" <?php endif; ?>>Office</option>
                  </select>
                  <?php if($errors->has('alternate_contact_type')): ?> <span class="help-block"> <strong><?php echo e($errors->first('alternate_contact_type')); ?></strong> </span> <?php endif; ?> </div>
                <div class="phone-div col-8">
                  <input type="hidden" name="alternate_country_code" class="country_code" value="<?php echo e(old('alternate_country_code') ?? $donorInfo->alternate_country_code); ?>"/>
                  <input type="text" class="form-control phone" id="phone" name="alternate_contact" value="<?php echo e(old('alternate_contact') ?? $donorInfo->alternate_contact); ?>" autocomplete="off">
                  <?php if($errors->has('alternate_contact')): ?> <span class="help-block"> <strong><?php echo e($errors->first('alternate_contact')); ?></strong> </span> <?php endif; ?> </div>
              </div>
            </div>
          </div>
          <div class="col-sm-12 col-md-6">
            <div class="form-group">
              <label for="inputEmail3" class="control-label col-form-label">Address<span class="asterrisk">*</span></label>
              <input id="autocomplete" placeholder="Enter Address" type="text" class="form-control" name="address" value="<?php echo e(old('address') ?? $donorInfo->address); ?>" autocomplete="off">
              <!--<textarea class="form-control" id="inputEmail3" name="address"><?php echo e(old('address')); ?></textarea>-->
              <?php if($errors->has('address')): ?> <span class="help-block"> <strong><?php echo e($errors->first('address')); ?></strong> </span> <?php endif; ?> </div>
          </div>
          <div class="col-sm-12 col-md-6"> </div>
          <div class="row col-12" id="address">
            <div class="col-6">
              <label class="control-label col-form-label">Street address</label>
              <input class="form-control" id="street_number" name="street_number" value="<?php echo e(old('street_number') ?? $donorInfo->street_number); ?>" autocomplete="off">
              <?php if($errors->has('street_number')): ?> <span class="help-block"> <strong><?php echo e($errors->first('street_number')); ?></strong> </span> <?php endif; ?> </div>
            <div class="col-6">
              <label class="control-label col-form-label">Route</label>
              <input class="form-control" id="route" name="street_route" value="<?php echo e(old('street_route') ?? $donorInfo->street_route); ?>" autocomplete="off">
              <?php if($errors->has('street_route')): ?> <span class="help-block"> <strong><?php echo e($errors->first('street_route')); ?></strong> </span> <?php endif; ?> </div>
            <div class="col-6">
              <label class="control-label col-form-label">City</label>
              <input class="form-control field" id="locality" name="city" value="<?php echo e(old('city') ?? $donorInfo->city); ?>" autocomplete="off">
              <?php if($errors->has('city')): ?> <span class="help-block"> <strong><?php echo e($errors->first('city')); ?></strong> </span> <?php endif; ?> </div>
            <div class="col-6">
              <label class="control-label col-form-label">State</label>
              <input class="form-control" id="administrative_area_level_1" name="state" value="<?php echo e(old('state') ?? $donorInfo->state); ?>" autocomplete="off">
              <?php if($errors->has('state')): ?> <span class="help-block"> <strong><?php echo e($errors->first('state')); ?></strong> </span> <?php endif; ?> </div>
            <div class="col-6">
              <label class="control-label col-form-label">Postal Code<span class="asterrisk">*</span></label>
              <input class="form-control" id="postal_code" name="postal_code" value="<?php echo e(old('postal_code') ?? $donorInfo->postal_code); ?>" autocomplete="off">
              <?php if($errors->has('postal_code')): ?> <span class="help-block"> <strong><?php echo e($errors->first('postal_code')); ?></strong> </span> <?php endif; ?> </div>
            <div class="col-6">
              <label class="control-label col-form-label">Country<span class="asterrisk">*</span></label>
              <input class="form-control" id="country" name="country" value="<?php echo e(old('country') ?? $donorInfo->country); ?>" autocomplete="off">
              <?php if($errors->has('country')): ?> <span class="help-block"> <strong><?php echo e($errors->first('country')); ?></strong> </span> <?php endif; ?> </div>
          </div>
        </div>
        <br />
        <br />
        <h4>Payment Information</h4>
        <div class="row">
          <div class="col-sm-12 col-md-6">
            <div class="form-group">
              <label for="inputEmail3" class="control-label col-form-label">Amount(CAD)<span class="asterrisk">*</span></label>
              <input type="text" class="form-control" id="inputEmail3" name="amount" value="<?php echo e(old('amount') ?? $receipt->amount); ?>" autocomplete="off">
              <?php if($errors->has('amount')): ?> <span class="help-block"> <strong><?php echo e($errors->first('amount')); ?></strong> </span> <?php endif; ?> </div>
          </div>
          <div class="col-sm-12 col-md-6">
            <div class="form-group">
              <label for="inputEmail3" class="control-label col-form-label">Mode of Payment<span class="asterrisk">*</span></label>
              <select name="payment_mode" id="mode_of_payment" class="form-control">
                <option value="">Mode of Payment</option>
                <option value="Cash" <?php if($receipt->payment_mode=='Cash'): ?> selected="selected" <?php endif; ?>>Cash</option>
                <option value="Cheque" <?php if($receipt->payment_mode=='Cheque'): ?> selected="selected" <?php endif; ?>>Cheque</option>
                <!--<option value="Pledge" <?php if(old('payment_mode')=='Pledge'): ?> selected="selected" <?php endif; ?>>Pledge</option>
                    <option value="Card" <?php if(old('payment_mode')=='Card'): ?> selected="selected" <?php endif; ?>>Card</option>-->
                <option value="Online" <?php if($receipt->payment_mode=='Online'): ?> selected="selected" <?php endif; ?>>Online/Website</option>
                <option value="E-Transfer" <?php if($receipt->payment_mode=='E-Transfer'): ?> selected="selected" <?php endif; ?>>E-Transfer</option>
                <option value="Pledge" <?php if($receipt->payment_mode=='Pledge'): ?> selected="selected" <?php endif; ?>>Pledge</option>
				<option value="Credit Card" <?php if($receipt->payment_mode=='Credit Card'): ?> selected="selected" <?php endif; ?>>Credit Card</option>
              </select>
              <?php if($errors->has('payment_mode')): ?> <span class="help-block"> <strong><?php echo e($errors->first('payment_mode')); ?></strong> </span> <?php endif; ?> </div>
          </div>
        </div>
        <div class="divPaymentOptions divCard mt-1" <?php if($receipt->payment_mode=='Card'): ?> style="display: block;" <?php else: ?> style="display: none;" <?php endif; ?>>
        <div class="row">
          <div class="col-sm-12 col-md-6">
            <div class="form-group">
              <label for="card_number">Card Number</label>
              <input type="number" name="card_number" id="card_number" class="form-control" placeholder="16 digit card number" autocomplete="off">
              <?php if($errors->has('card_number')): ?> <span class="help-block"> <strong><?php echo e($errors->first('card_number')); ?></strong> </span> <?php endif; ?> </div>
          </div>
          <div class="col-sm-12 col-md-6">
            <div class="row">
              <div class="col-4">
                <div class="form-group">
                  <label for="expiry_month">Expiry Month</label>
                  <select name="expiry_month" id="expiry_month" class="form-control">
                    <option value="01">Jan</option>
                    <option value="02">Feb</option>
                    <option value="03">Mar</option>
                    <option value="04">Apr</option>
                    <option value="05">May</option>
                    <option value="06">Jun</option>
                    <option value="07">Jul</option>
                    <option value="08">Aug</option>
                    <option value="09">Sep</option>
                    <option value="10">Oct</option>
                    <option value="11">Nov</option>
                    <option value="12">Dec</option>
                  </select>
                  <?php if($errors->has('expiry_month')): ?> <span class="help-block"> <strong><?php echo e($errors->first('expiry_month')); ?></strong> </span> <?php endif; ?> </div>
              </div>
              <div class="col-4">
                <div class="form-group">
                  <label for="expiry_year">Expiry Year</label>
                  <select name="expiry_year" id="expiry_year" class="form-control">
                    
                    
                    
                            
					  	<?php
					  	$firstYear = (int)date('Y');
						$lastYear = $firstYear + 10;
						?>
						
						<?php for($i=$firstYear;$i<=$lastYear;$i++): ?>
						{
							
                            
                    
                    
                    <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                    
                    
                    
                            
						}
						<?php endfor; ?>
                      
                          
                  
                  
                  </select>
                  <?php if($errors->has('expiry_year')): ?> <span class="help-block"> <strong><?php echo e($errors->first('expiry_year')); ?></strong> </span> <?php endif; ?> </div>
              </div>
              <div class="col-4">
                <div class="form-group">
                  <label for="expiry_year">CVV</label>
                  <input type="number" name="cvv" id="cvv" class="form-control" placeholder="CVV" autocomplete="off">
                  <?php if($errors->has('cvv')): ?> <span class="help-block"> <strong><?php echo e($errors->first('cvv')); ?></strong> </span> <?php endif; ?> </div>
              </div>
            </div>
          </div>
          <hr>
        </div>
      </div>
      <div class="divPaymentOptions divCheque mt-1"  <?php if($receipt->payment_mode=='Cheque'): ?> style="display: block;" <?php else: ?> style="display: none;" <?php endif; ?>>
      <div class="row">
        <div class="col-sm-12 col-md-6">
          <div>
            <label for="cheque_no">Cheque No.</label>
            <input class="form-control" type="text" name="cheque_no" id="cheque_no" placeholder="Cheque number" autocomplete="off">
            <?php if($errors->has('cheque_no')): ?> <span class="help-block"> <strong><?php echo e($errors->first('cheque_no')); ?></strong> </span> <?php endif; ?> </div>
        </div>
        <div class="col-sm-12 col-md-6">
          <div class="mt-1">
            <label for="cheque_date">Cheque Date</label>
            <input class="form-control" type="date" name="cheque_date" id="cheque_date" placeholder="Cheque date" autocomplete="off">
            <?php if($errors->has('cheque_date')): ?> <span class="help-block"> <strong><?php echo e($errors->first('cheque_date')); ?></strong> </span> <?php endif; ?> </div>
        </div>
        <hr>
      </div>
      </div>
      <div class="divPaymentOptions divPledge mt-1"  <?php if($receipt->payment_mode=='Pledge'): ?> style="display: block;" <?php else: ?> style="display: none;" <?php endif; ?>>
      <div class="row">
        <div class="col-sm-12 col-md-6">
          <div>
            <label for="pledge_date">Pledge Date</label>
            <input class="form-control" type="date" name="pledge_date" id="pledge_date" placeholder="Approx date to donate" autocomplete="off">
            <?php if($errors->has('pledge_date')): ?> <span class="help-block"> <strong><?php echo e($errors->first('pledge_date')); ?></strong> </span> <?php endif; ?> </div>
        </div>
        <hr>
      </div>
      </div>
      <div class="row">
        <div class="col-sm-12 col-md-6" style="display:none;">
          <div class="form-group">
            <label for="inputEmail3" class="control-label col-form-label">Mode of Payment<span class="asterrisk">*</span></label>
            <select name="payment_frequency" id="payment_frequency" class="form-control">
              <option value="One Time" selected="selected"> One Time Payment </option>
              <option value="Recurring"> Recurring Payment </option>
            </select>
            <?php if($errors->has('payment_frequency')): ?> <span class="help-block"> <strong><?php echo e($errors->first('payment_frequency')); ?></strong> </span> <?php endif; ?> </div>
        </div>
        <div class="col-sm-12 col-md-6">
          <div class="form-group">
            <label for="inputEmail3" class="control-label col-form-label">Payment Status<span class="asterrisk">*</span></label>
            <select name="payment_status" id="payment_status" class="form-control">
              <option value="Not Paid" <?php if($receipt->payment_status=="Not Paid"): ?> selected="selected" <?php endif; ?>>Not Paid</option>
              <option value="Paid" <?php if($receipt->payment_status=="Paid"): ?> selected="selected" <?php endif; ?>>Paid</option>
              <!--<option value="Cancelled">Cancelled</option>-->
            </select>
            <?php if($errors->has('payment_status')): ?> <span class="help-block"> <strong><?php echo e($errors->first('payment_status')); ?></strong> </span> <?php endif; ?> </div>
        </div>
      </div>
      <div class="row">
        <div class="col-sm-12 col-md-12">
          <div class="form-group">
            <label for="inputEmail3" class="control-label col-form-label">Remarks</label>
            <textarea type="text" class="form-control" id="inputEmail3" name="remarks" autocomplete="off"><?php echo e(old('remarks') ?? $receipt->remarks); ?></textarea>
            <?php if($errors->has('remarks')): ?> <span class="help-block"> <strong><?php echo e($errors->first('remarks')); ?></strong> </span> <?php endif; ?> </div>
        </div>
      </div>
      </div>
      <div class="card-body">
        <div class="form-group m-b-0 text-right">
          <button type="submit" class="btn btn-info waves-effect waves-light">Save Donation</button>
          <!--<a href="<?php echo e(route('admin.receipt.index')); ?>" class="btn btn-dark waves-effect waves-light deactive_button">Cancel</a>-->
        </div>
      </div>
    </form>
  </div>
  <?php $__env->startPush('scripts'); ?>
  <script>
$(document).on('change', '#mode_of_payment', function() {
                $('.divPaymentOptions').hide();
                if($(this).val().toLowerCase() == 'cheque') {
                    $('.divCheque').show();
					$('#payment_status').val('Not Paid');
                } else if($(this).val().toLowerCase() == 'pledge') {
                    $('.divPledge').show();
					$('#payment_status').val('Not Paid');
                } else if($(this).val().toLowerCase() == 'card') {
                    $('.divCard').show();
					$('#payment_status').val('Paid');
                }
				else
				{
				$('#payment_status').val('Paid');
				}
            });
</script>
  <?php $__env->stopPush(); ?> </div>
</div>
</div>
</div>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('admin.includes.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/donation/public_html/resources/views/admin/receipt/edit.blade.php ENDPATH**/ ?>